/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.ui.panel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.ui.ElementsHandler;
import org.homelinux.elabor.ui.Selector;
import org.homelinux.elabor.ui.panel.AbstractGenericSelectionModel;

public abstract class SelectionModelAdaptor<T extends Serializable>
extends AbstractGenericSelectionModel<T> {
    private static final long serialVersionUID = 1L;
    private ElementsHandler<T> lister;
    private List<T> elements;

    public SelectionModelAdaptor(ElementsHandler<T> lister, Selector selector) {
        super(selector);
        this.lister = lister;
        this.elements = this.lister.getElements();
    }

    @Override
    public T get(int index) {
        return (T)((Serializable)this.elements.get(index));
    }

    @Override
    public List<T> get(int[] indices) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int ii = 0; ii < indices.length; ++ii) {
            result.add(this.get(indices[ii]));
        }
        return result;
    }

    @Override
    public int indexOf(Object item) {
        return this.elements.indexOf(item);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    @Override
    public void append(T element) {
        this.lister.append(element);
        this.elements = this.lister.getElements();
        this.itemAppended();
    }

    public void addAfter(T element, T previous) {
        int index = this.elements.indexOf(previous);
        this.lister.addAfter(element, previous);
        this.elements = this.lister.getElements();
        this.fireContentsChanged(this, index, index + 1);
    }

    @Override
    public void removeElement(T element) {
        int index = this.elements.indexOf(element);
        this.removeElement(element, index);
    }

    @Override
    public void removeElementAt(int index) {
        Serializable element = (Serializable)this.elements.get(index);
        this.removeElement(element, index);
    }

    private void removeElement(T element, int index) {
        this.lister.remove(element, index);
        this.elements = this.lister.getElements();
        this.itemRemoved(index);
    }

    @Override
    public void set(int index, T element) {
        this.lister.set(index, element);
        this.elements = this.lister.getElements();
        this.itemChanged();
    }

    @Override
    public void moveDown(int index) {
        this.lister.moveDown(index);
        this.elements = this.lister.getElements();
        this.fireContentsChanged(this, index, index + 1);
    }
}

