/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.services;

import java.awt.Color;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.homelinux.elabor.scriptorium.ecomponents.AbstractValuedLeaf;
import org.homelinux.elabor.scriptorium.ecomponents.Annotation;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.ecomponents.Description;
import org.homelinux.elabor.scriptorium.ecomponents.DescriptionItem;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.Enunciatio;
import org.homelinux.elabor.scriptorium.ecomponents.Formula;
import org.homelinux.elabor.scriptorium.ecomponents.Image;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReferenceComposite;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyRefererInterface;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.ReadingReference;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.ecomponents.WitnessId;
import org.homelinux.elabor.scriptorium.ecomponents.WitnessesIds;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.AbstractPointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.NullEditionVisitor;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapeGUI;
import org.homelinux.elabor.scriptorium.ndraft.DiameterDirectionHandler;
import org.homelinux.elabor.scriptorium.ndraft.DirectionHandler;
import org.homelinux.elabor.scriptorium.ndraft.TangentDirectionHandler;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractConicAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ActionPoint;
import org.homelinux.elabor.scriptorium.ndraft.actions.AxisAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.EllipseAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.EqualToAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.HyperbolaAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ParabolaAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.SnapAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineDirectionAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.TangentAction;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.text.Format;

public class Highlighter
extends NullEditionVisitor {
    private static final DecimalFormat FORMAT = Format.newDecimalFormat(Locale.getDefault(), "#.##");
    protected String text = "";
    private Ontology activeOntology;
    private Ontology keywordOntology;
    private Ontology mathConceptOntology;
    private Ontology nameOntology;
    private Ontology placeOntology;
    private Ontology tongueOntology;
    private Ontology variantOntology;
    private Ontology workOntology;
    private Ontology partOntology;
    private Iterable<ScriptoriumPoint> drawingPoints;
    private Iterable<ComputeAction> drawingActions;
    private Preferences preferences = Preferences.getInstance();

    public Highlighter(OntologyInitialiser initialiser) {
        EditionManager manager = EditionManager.getInstance();
        this.tongueOntology = manager.getTonguesOntology();
        this.keywordOntology = manager.getKeywordsOntology();
        this.mathConceptOntology = manager.getMathConceptsOntology();
        this.nameOntology = manager.getNamesOntology();
        this.placeOntology = manager.getPlacesOntology();
        this.variantOntology = manager.getVariantsOntology();
        this.workOntology = manager.getWorksOntology();
        this.partOntology = manager.getTextPartsOntology();
        this.activeOntology = initialiser.getOntology(this.tongueOntology, this.keywordOntology, this.mathConceptOntology, this.nameOntology, this.placeOntology, this.variantOntology, this.workOntology, this.partOntology);
    }

    public String getRawText() {
        String result = this.text;
        this.text = "";
        return result;
    }

    public String getText() {
        String result = "<html>" + this.text + "</html>";
        this.text = "";
        return result;
    }

    public void setDrawingPoints(Iterable<ScriptoriumPoint> drawingPoints) {
        this.drawingPoints = drawingPoints;
    }

    public void setDrawingActions(Iterable<ComputeAction> drawingActions) {
        this.drawingActions = drawingActions;
    }

    private void putPoint(String colorString, String id, String pointName) {
        this.text = String.valueOf(this.text) + " <font color='#" + colorString + "'>" + pointName + "</font>" + " " + id;
    }

    private void visitEditionComponent(EditionComponent<?> token) {
        this.text = String.valueOf(this.text) + token.toString();
    }

    @Override
    public void visit(Variant variant) {
        List<VariantItem> items = variant.getVariantItems();
        if (items.size() > 0) {
            this.text = String.valueOf(this.text) + "<font color='blue'>";
            items.get(0).accept(this);
            this.text = String.valueOf(this.text) + "</font>";
            int i = 1;
            while (i < items.size()) {
                this.text = String.valueOf(this.text) + " ";
                items.get(i).accept(this);
                ++i;
            }
        }
    }

    @Override
    public void visit(VariantItem variant_item) {
        Reading reading = variant_item.getReading();
        if (reading != null) {
            reading.accept(this);
            List<Description> descriptions = variant_item.getDescriptions();
            boolean start = true;
            if (descriptions.size() > 0) {
                this.text = String.valueOf(this.text) + " <font color='black'>[";
                for (Description description : descriptions) {
                    if (start) {
                        start = false;
                    } else {
                        this.text = String.valueOf(this.text) + " ";
                    }
                    description.accept(this);
                }
                this.text = String.valueOf(this.text) + "]</font>";
            }
        }
    }

    @Override
    public void visit(Reading reading) {
        this.visitEditionComponent(reading);
    }

    @Override
    public void visit(Description description) {
        WitnessesIds witnesses_ids = description.getWitnessesIds();
        if (witnesses_ids != null) {
            witnesses_ids.accept(this);
        }
        List<DescriptionItem> items = description.getItems();
        for (DescriptionItem item : items) {
            if (this.text.lastIndexOf("[") != this.text.length() - 1) {
                this.text = String.valueOf(this.text) + " ";
            }
            item.accept(this);
        }
    }

    @Override
    public void visit(DescriptionItem item) {
        if (item.getType() != null) {
            switch (item.getType()) {
                case ONTOLOGY_REFERENCE_TYPE: {
                    this.activeOntology = this.variantOntology;
                    item.getOntologyReference().accept(this);
                    break;
                }
                case READING_TYPE: {
                    item.getReading().accept(this);
                    break;
                }
                case READING_REFERENCE_TYPE: {
                    item.getReadingReference().accept(this);
                }
            }
        }
    }

    @Override
    public void visit(WitnessesIds witnesses_ids) {
        boolean start = true;
        for (WitnessId wId : witnesses_ids.getWitnessIds()) {
            if (start) {
                start = false;
            } else {
                this.text = String.valueOf(this.text) + "/";
            }
            wId.accept(this);
        }
    }

    @Override
    public void visit(WitnessId witness_id) {
        this.text = String.valueOf(this.text) + "<font color='#f05050'>";
        this.text = String.valueOf(this.text) + witness_id.getId();
        this.text = String.valueOf(this.text) + "</font>";
    }

    private void visitOntologyNonvaluedComposite(OntologyRefererInterface token, Ontology ontology) {
        List<OntologyReference> references = token.getOntologyReferences();
        this.activeOntology = ontology;
        for (OntologyReference reference : references) {
            this.text = String.valueOf(this.text) + " - ";
            reference.accept(this);
        }
    }

    private void visitOntologyValuedComposite(OntologyReferenceComposite<?> token, Ontology ontology) {
        Content content = token.getContent();
        this.text = String.valueOf(this.text) + content.toString();
        this.visitOntologyNonvaluedComposite(token, ontology);
    }

    @Override
    public void visit(Name name) {
        this.visitOntologyValuedComposite(name, this.nameOntology);
        boolean incerto = name.isIncerto();
        if (incerto) {
            this.text = String.valueOf(this.text) + "[*]";
        }
    }

    @Override
    public void visit(MathConcept mathConcept) {
        this.visitOntologyValuedComposite(mathConcept, this.mathConceptOntology);
    }

    @Override
    public void visit(Place place) {
        this.visitOntologyValuedComposite(place, this.placeOntology);
    }

    @Override
    public void visit(Work work) {
        this.visitOntologyValuedComposite(work, this.workOntology);
    }

    @Override
    public void visit(Tongue tongue) {
        this.visitOntologyValuedComposite(tongue, this.tongueOntology);
    }

    @Override
    public void visit(TextPart textPart) {
        this.text = String.valueOf(this.text) + textPart.getOrder();
        this.visitOntologyNonvaluedComposite(textPart, this.partOntology);
    }

    @Override
    public void visit(DateToken dateToken) {
        this.visitEditionComponent(dateToken);
        Date date = dateToken.getDate();
        if (date != null) {
            DateFormat dateFormat = DateFormat.getDateInstance(2);
            String dateString = dateFormat.format(date);
            this.text = String.valueOf(this.text) + " - <font color='green'>" + dateString + "</font>";
        }
    }

    @Override
    public void visit(Citation citation) {
        this.visitEditionComponent(citation);
    }

    @Override
    public void visit(Enunciatio enunciatio) {
        this.visitEditionComponent(enunciatio);
    }

    @Override
    public void visit(Formula formula) {
        this.visitEditionComponent(formula);
    }

    @Override
    public void visit(OntologyReference reference) {
        String id = reference.getOntologyId();
        OntologyClass ontologyClass = this.activeOntology.getOntologyClassById(id);
        if (ontologyClass == null) {
            this.text = String.valueOf(this.text) + "(" + id + "?)";
        } else {
            String ontologyClassDescription = ontologyClass.toString();
            String argument = reference.getArgument();
            if (ontologyClassDescription.equals("Descriptio")) {
                ontologyClassDescription = "";
            }
            if (id.length() > 0) {
                Color color = this.preferences.getColor("descriptions_color");
                String colorString = Integer.toHexString(color.getRGB()).substring(2);
                this.text = String.valueOf(this.text) + "<font color='#" + colorString + "'>" + ontologyClassDescription + "</font>";
                if (argument.length() > 0) {
                    this.text = String.valueOf(this.text) + " ";
                }
            }
            if (argument.length() > 0) {
                this.text = String.valueOf(this.text) + "<i>" + argument + "</i>";
            }
        }
    }

    @Override
    public void visit(ReadingReference reference) {
        this.text = String.valueOf(this.text) + "&amp;";
    }

    @Override
    public void visit(ScriptoriumShape scriptoriumShape) {
        AbstractShape<?> inner = scriptoriumShape.getShape();
        inner.accept(this);
    }

    @Override
    public void visit(ComputeAction action) {
        AbstractAction<?> inner = action.getAction();
        inner.accept(this);
    }

    @Override
    public void visit(ScriptoriumStyle scriptoriumStyle) {
        this.text = String.valueOf(this.text) + scriptoriumStyle.getName();
    }

    @Override
    public void visit(ScriptoriumPoint point) {
        String id = Integer.toString(point.getId());
        String label = point.getLabel();
        double x = point.getX();
        double y = point.getY();
        String coordinates = "(" + FORMAT.format(x) + "," + FORMAT.format(y) + ")";
        this.text = String.valueOf(this.text) + id;
        int subid = point.getSubId();
        if (subid > 0) {
            this.text = String.valueOf(this.text) + "->" + subid;
        }
        if (!label.isEmpty()) {
            String arab = "<font color='#FFFFFF' size='0'>i</font>";
            String separator = "<font color='#FF0000' size>\u00b7</font>";
            this.text = String.valueOf(this.text) + arab + separator + label + arab;
        }
        this.text = String.valueOf(this.text) + coordinates;
    }

    @Override
    public void visit(AbstractShape<?> innerShape) {
        ShapeGUI shapeGUI = new ShapeGUI(innerShape);
        if (!innerShape.isComplete()) {
            Color bgColor = this.preferences.getColor("lines_uncomplete_bgcolor");
            String bgColorString = Integer.toHexString(bgColor.getRGB()).substring(2);
            this.text = String.valueOf(this.text) + "<body bgcolor='#" + bgColorString + "'>";
        }
        this.text = String.valueOf(this.text) + shapeGUI.getGUIName();
        String label = innerShape.getLabel();
        if (!label.isEmpty()) {
            Color nameColor = this.preferences.getColor("lines_name_color");
            String nameColorString = Integer.toHexString(nameColor.getRGB()).substring(2);
            this.text = String.valueOf(this.text) + " <font color='#" + nameColorString + "'>" + label + "</font>";
        }
        this.text = String.valueOf(this.text) + ":";
        Color color = innerShape.isComplete() ? this.preferences.getColor("lines_complete_color") : this.preferences.getColor("lines_uncomplete_color");
        String colorString = Integer.toHexString(color.getRGB()).substring(2);
        int position = 0;
        List<ScriptoriumPoint> shapePoints = ShapeAdapter.getShapePoints(innerShape, this.drawingPoints);
        for (ScriptoriumPoint point : shapePoints) {
            String id = Integer.toString(point.getId());
            String pointName = innerShape.getPointName(position);
            this.putPoint(colorString, id, pointName);
            if (!point.getLabel().isEmpty()) {
                label = point.getLabel();
                this.text = String.valueOf(this.text) + "\u00b7" + label;
            }
            if (++position == shapePoints.size()) continue;
            this.text = String.valueOf(this.text) + ",";
        }
        while (position < innerShape.getNeededNumberOfPoints()) {
            String pointName = innerShape.getPointName(position);
            this.putPoint(colorString, "?", pointName);
            ++position;
        }
        this.text = String.valueOf(this.text) + "</font>";
    }

    @Override
    public void visit(PointReference reference) {
        ScriptoriumPoint point = ShapeAdapter.getPoint(reference, this.drawingPoints);
        this.visitAbstractReference(point);
    }

    @Override
    public void visit(ActionPoint reference) {
        ScriptoriumPoint point = ShapeAdapter.getPoint(reference, this.drawingPoints);
        this.visitAbstractReference(point);
    }

    private void visitAbstractReference(ScriptoriumPoint point) {
        String id = Integer.toString(point.getId());
        this.text = String.valueOf(this.text) + id;
        String label = point.getLabel();
        if (!label.isEmpty()) {
            this.text = String.valueOf(this.text) + "-" + label;
        }
    }

    @Override
    public void visit(Annotation annotation) {
        this.defaultValuedLeafVisit(annotation);
    }

    @Override
    public void visit(Image image) {
        String caption = image.getCaption();
        if (caption.isEmpty()) {
            this.defaultValuedLeafVisit(image);
        } else {
            this.text = String.valueOf(this.text) + caption;
        }
    }

    private void defaultValuedLeafVisit(AbstractValuedLeaf<?> leaf) {
        String value = leaf.getValue();
        if (value == null || value.isEmpty()) {
            value = "<em>---------</em>";
        }
        this.text = String.valueOf(this.text) + value;
    }

    @Override
    public void visit(AxisAction action) {
        Color color = this.preferences.getColor("lines_complete_color");
        this.text = String.valueOf(this.text) + "axis ";
        this.text = String.valueOf(this.text) + Highlighter.colorText("fixed ", color);
        for (ScriptoriumPoint point : action.getFixedPoints(this.drawingPoints)) {
            this.visitPoint(point);
            this.text = String.valueOf(this.text) + " - ";
        }
        this.visitAction(action);
    }

    @Override
    public void visit(StraightLineAction action) {
        Color color = this.preferences.getColor("lines_complete_color");
        this.text = String.valueOf(this.text) + "straight line ";
        this.text = String.valueOf(this.text) + Highlighter.colorText("fixed ", color);
        for (ScriptoriumPoint point : action.getFixedPoints(this.drawingPoints)) {
            this.visitPoint(point);
            this.text = String.valueOf(this.text) + " - ";
        }
        this.visitAction(action);
    }

    @Override
    public void visit(StraightLineDirectionAction action) {
        Color color = this.preferences.getColor("lines_complete_color");
        int fixedPointRef = action.getFixedPoint();
        ScriptoriumPoint fixedPoint = ShapeAdapter.getReferredItem(fixedPointRef, this.drawingPoints);
        this.text = String.valueOf(this.text) + "straight line ";
        this.text = String.valueOf(this.text) + Highlighter.colorText("fixed ", color);
        this.visitPoint(fixedPoint);
        this.visitDirection(" line", action, color);
        this.text = String.valueOf(this.text) + " - ";
        this.visitAction(action);
    }

    @Override
    public void visit(EqualToAction action) {
        Color color = this.preferences.getColor("lines_complete_color");
        int fixedPointRef = action.getFixedPoint();
        int movingPointRef = action.getMovingPoint();
        int firstPointRef = action.getFirstDistancePoint();
        int secondPointRef = action.getSecondDistancePoint();
        ScriptoriumPoint fixedPoint = ShapeAdapter.getReferredItem(fixedPointRef, this.drawingPoints);
        ScriptoriumPoint movingPoint = ShapeAdapter.getReferredItem(movingPointRef, this.drawingPoints);
        ScriptoriumPoint firstPoint = ShapeAdapter.getReferredItem(firstPointRef, this.drawingPoints);
        ScriptoriumPoint secondPoint = ShapeAdapter.getReferredItem(secondPointRef, this.drawingPoints);
        this.text = String.valueOf(this.text) + "equal to ";
        this.text = String.valueOf(this.text) + Highlighter.colorText("fixed ", color);
        this.visitPoint(fixedPoint);
        this.text = String.valueOf(this.text) + Highlighter.colorText(" moving ", color);
        this.visitPoint(movingPoint);
        this.text = String.valueOf(this.text) + Highlighter.colorText(" distance ", color);
        this.visitPoint(firstPoint);
        this.text = String.valueOf(this.text) + Highlighter.colorText(" to ", color);
        this.visitPoint(secondPoint);
    }

    @Override
    public void visit(EllipseAction action) {
        this.text = String.valueOf(this.text) + "ellipse";
        this.visitConic(action);
    }

    @Override
    public void visit(HyperbolaAction action) {
        Color color = this.preferences.getColor("lines_complete_color");
        this.text = String.valueOf(this.text) + "hyperbola";
        this.visitConic(action);
        this.text = String.valueOf(this.text) + Highlighter.colorText(" limit points ", color);
        this.visitPoint(action.getStartPoint(this.drawingPoints));
        this.text = String.valueOf(this.text) + ", ";
        this.visitPoint(action.getEndPoint(this.drawingPoints));
    }

    @Override
    public void visit(SnapAction action) {
        Color color = this.preferences.getColor("lines_complete_color");
        List<PointReference> pointReferences = action.getPointReferences();
        List<ScriptoriumPoint> points = ShapeAdapter.getReferredPoints(pointReferences, this.drawingPoints);
        this.text = String.valueOf(this.text) + "snap";
        this.text = String.valueOf(this.text) + Highlighter.colorText(" points ", color);
        this.visitPoints(points);
        int targetRef = action.getTarget();
        ComputeAction target = ShapeAdapter.getReferredAction(targetRef, this.drawingActions);
        if (target != null) {
            this.text = String.valueOf(this.text) + Highlighter.colorText(" to ", color);
            AbstractAction<?> targetAction = target.getAction();
            targetAction.accept(this);
        }
    }

    @Override
    public void visit(TangentAction action) {
        Color color = this.preferences.getColor("lines_complete_color");
        this.text = String.valueOf(this.text) + "tangent";
        this.text = String.valueOf(this.text) + Highlighter.colorText(" point ", color);
        ScriptoriumPoint point = action.getFixedPoint(this.drawingPoints);
        this.visitPoint(point);
        this.text = String.valueOf(this.text) + Highlighter.colorText(" points ", color);
        List<ActionPoint> actionPoints = action.getActionPoints();
        List<ScriptoriumPoint> points = ShapeAdapter.getReferredPoints(actionPoints, this.drawingPoints);
        this.visitPoints(points);
        ComputeAction conicAction = action.getCurve(this.drawingActions);
        this.text = String.valueOf(this.text) + Highlighter.colorText(" to ", color);
        this.visit(conicAction);
        this.text = String.valueOf(this.text) + Highlighter.colorText(" limits ", color);
        this.text = String.valueOf(this.text) + "(";
        ScriptoriumPoint startPoint = action.getStartPoint(this.drawingPoints);
        this.visitPoint(startPoint);
        this.text = String.valueOf(this.text) + ",";
        ScriptoriumPoint endPoint = action.getEndPoint(this.drawingPoints);
        this.visitPoint(endPoint);
        this.text = String.valueOf(this.text) + ")";
    }

    @Override
    public void visit(ParabolaAction action) {
        Color color = this.preferences.getColor("lines_complete_color");
        int vertexRef = action.getVertex();
        int passingByPointRef = action.getPassingByPoint();
        int startRef = action.getStartPoint();
        int endRef = action.getEndPoint();
        ScriptoriumPoint vertex = ShapeAdapter.getReferredItem(vertexRef, this.drawingPoints);
        ScriptoriumPoint passingByPoint = ShapeAdapter.getReferredItem(passingByPointRef, this.drawingPoints);
        ScriptoriumPoint startPoint = ShapeAdapter.getReferredItem(startRef, this.drawingPoints);
        ScriptoriumPoint endPoint = ShapeAdapter.getReferredItem(endRef, this.drawingPoints);
        this.text = String.valueOf(this.text) + "parabola ";
        this.text = String.valueOf(this.text) + Highlighter.colorText("vertex ", color);
        this.visitPoint(vertex);
        this.text = String.valueOf(this.text) + Highlighter.colorText(" passing by ", color);
        this.visitPoint(passingByPoint);
        DiameterDirectionHandler diameterHandler = new DiameterDirectionHandler(action);
        this.visitDirection(" diam", diameterHandler, color);
        TangentDirectionHandler tangentHandler = new TangentDirectionHandler(action);
        this.visitDirection(" ord", tangentHandler, color);
        this.text = String.valueOf(this.text) + Highlighter.colorText(" limits ", color);
        this.text = String.valueOf(this.text) + "(";
        this.visitPoint(startPoint);
        this.text = String.valueOf(this.text) + ",";
        this.visitPoint(endPoint);
        this.text = String.valueOf(this.text) + ")";
    }

    private void visitConic(AbstractConicAction<?> action) {
        boolean hasFixedPoints;
        Color color = this.preferences.getColor("lines_complete_color");
        ScriptoriumPoint vertex1 = action.getVertex1Point(this.drawingPoints);
        ScriptoriumPoint passingByPoint = action.getPassingByPoint(this.drawingPoints);
        List<ScriptoriumPoint> fixedPoints = action.getFixedPoints(this.drawingPoints);
        int centerRef = action.getCenter();
        boolean byCenter = centerRef != 0;
        this.text = String.valueOf(this.text) + Highlighter.colorText(" vertex ", color);
        this.visitPoint(vertex1);
        boolean bl = hasFixedPoints = !fixedPoints.isEmpty();
        if (byCenter || hasFixedPoints) {
            this.text = String.valueOf(this.text) + Highlighter.colorText(" center ", color);
            ScriptoriumPoint center = ShapeAdapter.getReferredItem(centerRef, this.drawingPoints);
            this.visitPoint(center);
        }
        if (!byCenter || hasFixedPoints) {
            this.text = String.valueOf(this.text) + Highlighter.colorText(" vertex ", color);
            ScriptoriumPoint vertex2 = action.getVertex2Point(this.drawingPoints);
            this.visitPoint(vertex2);
        }
        if (hasFixedPoints) {
            this.text = String.valueOf(this.text) + Highlighter.colorText(" fixed points ", color);
            this.visitPoints(fixedPoints);
        }
        this.text = String.valueOf(this.text) + Highlighter.colorText(" passing by ", color);
        this.visitPoint(passingByPoint);
    }

    private void visitDirection(String label, DirectionHandler handler, Color color) {
        double dx = handler.getDx();
        double dy = handler.getDy();
        if (dx == 0.0 && dy == 0.0) {
            this.text = String.valueOf(this.text) + Highlighter.colorText(String.valueOf(label) + " par", color) + " (";
            int firstPointId = handler.getFirstPoint();
            ScriptoriumPoint firstPoint = ShapeAdapter.getReferredItem(firstPointId, this.drawingPoints);
            this.visitPoint(firstPoint);
            this.text = String.valueOf(this.text) + ",";
            int secondPointId = handler.getSecondPoint();
            ScriptoriumPoint secondPoint = ShapeAdapter.getReferredItem(secondPointId, this.drawingPoints);
            this.visitPoint(secondPoint);
            this.text = String.valueOf(this.text) + ")";
        } else {
            double direction = Math.atan2(dy, dx) * 180.0 / Math.PI;
            String directionStr = FORMAT.format(direction);
            this.text = String.valueOf(this.text) + Highlighter.colorText(String.valueOf(label) + " dir", color) + " " + directionStr;
        }
    }

    private static String colorText(String value, Color color) {
        String colorString = Integer.toHexString(color.getRGB()).substring(2);
        return "<font color='#" + colorString + "'>" + value + "</font>";
    }

    private void visitAction(AbstractAction<?> action) {
        this.visitReferences(action.getPointReferences());
        this.visitReferences(action.getActionPoints());
    }

    private <T extends AbstractPointReference<T>> void visitReferences(List<T> pointReferences) {
        if (!pointReferences.isEmpty()) {
            Color color = this.preferences.getColor("lines_complete_color");
            List<ScriptoriumPoint> points = ShapeAdapter.getReferredPoints(pointReferences, this.drawingPoints);
            this.text = String.valueOf(this.text) + Highlighter.colorText("points", color);
            this.visitPoints(points);
        }
    }

    private void visitPoints(List<ScriptoriumPoint> points) {
        this.text = String.valueOf(this.text) + " (";
        int position = 0;
        for (ScriptoriumPoint point : points) {
            this.visitPoint(point);
            if (++position == points.size()) continue;
            this.text = String.valueOf(this.text) + ", ";
        }
        this.text = String.valueOf(this.text) + ")";
    }

    private void visitPoint(ScriptoriumPoint point) {
        String id = Integer.toString(point.getId());
        this.text = String.valueOf(this.text) + id;
        if (!point.getLabel().trim().isEmpty()) {
            String label = point.getLabel();
            this.text = String.valueOf(this.text) + "\u00b7" + label;
        }
    }
}

