/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.Shape;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.w3c.dom.Element;

public final class EqualToAction
extends AbstractAction<EqualToAction> {
    private static final String FIXED_POINT = "fixed_point";
    private static final String MOVING_POINT = "moving_point";
    private static final String FIRST_DISTANCE_POINT = "first_distance_point";
    private static final String SECOND_DISTANCE_POINT = "second_distance_point";

    public EqualToAction() {
    }

    public EqualToAction(Element element) {
        super(element);
    }

    @Override
    public String getElementName() {
        return "equal_to";
    }

    @Override
    protected EqualToAction make(Element element) {
        return new EqualToAction(element);
    }

    public void setFixedPoint(PointReference point) {
        this.setIntAttribute(FIXED_POINT, point.getId());
    }

    public void setMovingPoint(PointReference point) {
        this.setIntAttribute(MOVING_POINT, point.getId());
    }

    public void setFirstDistancePoint(PointReference point) {
        this.setIntAttribute(FIRST_DISTANCE_POINT, point.getId());
    }

    public void setSecondDistancePoint(PointReference point) {
        this.setIntAttribute(SECOND_DISTANCE_POINT, point.getId());
    }

    public int getFixedPoint() {
        return this.getIntAttribute(FIXED_POINT);
    }

    public int getMovingPoint() {
        return this.getIntAttribute(MOVING_POINT);
    }

    public int getFirstDistancePoint() {
        return this.getIntAttribute(FIRST_DISTANCE_POINT);
    }

    public int getSecondDistancePoint() {
        return this.getIntAttribute(SECOND_DISTANCE_POINT);
    }

    @Override
    public String toString() {
        return "Equal to" + this.getStringAttribute(FIXED_POINT) + " - " + this.getStringAttribute(MOVING_POINT) + " - " + this.getStringAttribute(FIRST_DISTANCE_POINT) + " - " + this.getStringAttribute(SECOND_DISTANCE_POINT);
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void execute(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> actions) throws InvalidValueException {
        int movingPointRef = this.getMovingPoint();
        ScriptoriumPoint movingPoint = ShapeAdapter.getReferredItem(movingPointRef, drawingPoints);
        int fixedPointRef = this.getFixedPoint();
        ScriptoriumPoint fixedPoint = ShapeAdapter.getReferredItem(fixedPointRef, drawingPoints);
        double dx = movingPoint.getX() - fixedPoint.getX();
        double dy = movingPoint.getY() - fixedPoint.getY();
        if (dx == 0.0 && dy == 0.0) {
            throw new InvalidValueException("moving point is equal to fixed point");
        }
        int firstRef = this.getFirstDistancePoint();
        ScriptoriumPoint firstPoint = ShapeAdapter.getReferredItem(firstRef, drawingPoints);
        int secondRef = this.getSecondDistancePoint();
        ScriptoriumPoint secondPoint = ShapeAdapter.getReferredItem(secondRef, drawingPoints);
        double distance = firstPoint.getPoint2D().distance(secondPoint.getPoint2D());
        double normalisation = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
        double x = fixedPoint.getX() + (dx /= normalisation) * distance;
        double y = fixedPoint.getY() + (dy /= normalisation) * distance;
        movingPoint.setSnap(x, y);
    }

    @Override
    protected void project(DraftVector vector, ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
    }

    @Override
    protected Shape computeShape(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        return null;
    }

    @Override
    public boolean isConicBy(ScriptoriumPoint point) {
        return false;
    }

    @Override
    protected DraftVector getTangent(ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints) {
        return null;
    }

    @Override
    public boolean isConic() {
        return false;
    }
}

