/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.List;
import org.apache.commons.math3.util.Pair;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Equation;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractConicAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.w3c.dom.Element;

public final class EllipseAction
extends AbstractConicAction<EllipseAction> {
    public EllipseAction() {
    }

    public EllipseAction(Element element) {
        super(element);
    }

    @Override
    public String getElementName() {
        return "ellipse";
    }

    @Override
    protected EllipseAction make(Element element) {
        return new EllipseAction(element);
    }

    @Override
    public String toString() {
        return "Ellipse " + this.getVertex1() + " - " + this.getVertex2() + " - " + this.getPassingBy();
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void project(Iterable<ScriptoriumPoint> points, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        AffineTransform inverse;
        Pair<Equation, Point2D[]> common = this.getCommon(drawingPoints);
        Equation equation = (Equation)common.getFirst();
        AffineTransform transform = equation.getTransform();
        try {
            inverse = transform.createInverse();
        }
        catch (NoninvertibleTransformException exc) {
            throw new RuntimeException(exc);
        }
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        for (ScriptoriumPoint point : points) {
            Point2D point2D = point.getPoint2D();
            Point2D image = inverse.transform(point2D, null);
            double x = image.getX();
            double y = image.getY();
            double d = image.distance(origin);
            double cos = x / d;
            double sin = y / d;
            image = new Point2D.Double(cos, sin);
            transform.transform(image, point2D);
            point.setSnap(point2D);
        }
    }

    private Pair<Equation, Point2D[]> getCommon(Iterable<ScriptoriumPoint> drawingPoints) {
        Point2D point;
        Point2D center2D;
        Point2D vertex22D;
        ScriptoriumPoint vertex1 = this.getVertex1Point(drawingPoints);
        ScriptoriumPoint passingBy = this.getPassingByPoint(drawingPoints);
        int centerRef = this.getCenter();
        Point2D vertex12D = vertex1.getPoint2D();
        Point2D passingBy2D = passingBy.getPoint2D();
        List<ScriptoriumPoint> fixedPoints = this.getFixedPoints(drawingPoints);
        if (fixedPoints.isEmpty()) {
            if (centerRef == 0) {
                int vertex2Ref = this.getVertex2();
                ScriptoriumPoint vertex2 = ShapeAdapter.getReferredItem(vertex2Ref, drawingPoints);
                vertex22D = vertex2.getPoint2D();
                center2D = GeometricHelper.middlePoint(vertex12D, vertex22D);
            } else {
                ScriptoriumPoint center = ShapeAdapter.getReferredItem(centerRef, drawingPoints);
                center2D = center.getPoint2D();
                vertex22D = GeometricHelper.symmetric(vertex12D, center2D);
            }
        } else {
            ScriptoriumPoint vertex2 = this.getVertex2Point(drawingPoints);
            vertex22D = vertex2.getPoint2D();
            ScriptoriumPoint center = this.getCenterPoint(drawingPoints);
            center2D = center.getPoint2D();
        }
        Point2D centerSymm = GeometricHelper.symmetric(passingBy2D, center2D);
        DraftVector axis = new DraftVector(vertex12D, center2D);
        Point2D axisSymm = GeometricHelper.symmetric(passingBy2D, axis);
        if (axisSymm.distance(centerSymm) < 1.0E-8) {
            double semiD1 = passingBy2D.distance(center2D);
            double semiD2 = vertex12D.distance(center2D);
            DraftVector d1Vector = new DraftVector(center2D, passingBy2D);
            Point2D p1 = GeometricHelper.shift(d1Vector, semiD1 * Math.sqrt(2.0));
            DraftVector d2Vector = new DraftVector(center2D, vertex12D);
            Point2D p2 = GeometricHelper.shift(d2Vector, semiD2 * Math.sqrt(2.0));
            point = GeometricHelper.middlePoint(p1, p2);
        } else {
            point = axisSymm;
        }
        Point2D[] points = new Point2D[]{vertex12D, vertex22D, passingBy2D, centerSymm, point};
        Equation equation = GeometricHelper.computeApproxEquation(points);
        return new Pair((Object)equation, (Object)points);
    }

    @Override
    protected Shape computeShape(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        Shape shape;
        Pair<Equation, Point2D[]> common = this.getCommon(drawingPoints);
        Equation equation = (Equation)common.getFirst();
        Point2D[] points = (Point2D[])common.getSecond();
        try {
            shape = GeometricHelper.buildConic(equation, false, null, null, points);
        }
        catch (NoninvertibleTransformException exc) {
            shape = GeometricHelper.buildLine(points);
        }
        return shape;
    }

    @Override
    protected DraftVector getTangent(ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints) {
        Pair<Equation, Point2D[]> common = this.getCommon(drawingPoints);
        Equation equation = (Equation)common.getFirst();
        Point2D point2D = point.getPoint2D();
        return equation.tangent(point2D);
    }
}

