/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ndraft.ChoosePointsArea;
import org.homelinux.elabor.scriptorium.ndraft.DirectionArea;
import org.homelinux.elabor.scriptorium.ndraft.FixedLineDirection;
import org.homelinux.elabor.scriptorium.ndraft.LimitPointsActionDialog;
import org.homelinux.elabor.scriptorium.ndraft.LineDirection;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingFrame;
import org.homelinux.elabor.scriptorium.ndraft.SingleButtonHandler;
import org.homelinux.elabor.ui.UITools;

public class ParabolaActionDialog
extends LimitPointsActionDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final NDraftDrawingFrame frame;
    private final List<ScriptoriumPoint> points;
    private DirectionArea diameterDirArea;
    private DirectionArea tangentDirArea;
    private SingleButtonHandler handler;

    public ParabolaActionDialog(NDraftDrawingFrame frame, List<ScriptoriumPoint> points, Iterable<ScriptoriumPoint> drawingPoints) {
        this.setModal(false);
        this.frame = frame;
        this.setSize(500, 600);
        this.setTitle("choose parabola parameters");
        this.setDefaultCloseOperation(2);
        this.points = points;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        this.handler = new SingleButtonHandler();
        ChoosePointsArea vertexArea = new ChoosePointsArea(this.handler, "vertex", this.points, false, false);
        UITools.addComponent(contentPane, vertexArea, 0, 0, 1, 1, 100, 0, 1, 2);
        this.diameterDirArea = new DirectionArea("diameter direction");
        UITools.addComponent(contentPane, this.diameterDirArea, 0, 1, 1, 1, 100, 0, 1, 2);
        this.tangentDirArea = new DirectionArea("ordinate direction", drawingPoints);
        UITools.addComponent(contentPane, this.tangentDirArea, 0, 2, 1, 1, 100, 0, 1, 2);
        JScrollPane limitsArea = this.buildLimitsPanel(drawingPoints);
        UITools.addComponent(contentPane, limitsArea, 0, 3, 1, 1, 100, 10, 1, 2);
        JButton button = new JButton("ok");
        button.addActionListener(this);
        UITools.addComponent(contentPane, button, 0, 4, 1, 1, 100, 0, 3, 5);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ScriptoriumPoint vertex = this.handler.getSelectedPoint();
        if (vertex == null) {
            JOptionPane.showMessageDialog(null, "you should select the vertex");
        } else if (this.limitPoints.size() == 2) {
            ScriptoriumPoint passingByPoint = this.getPassingByPoint(vertex);
            try {
                FixedLineDirection diameterDirection = this.diameterDirArea.getFixedLineDirection();
                LineDirection tangentDirection = this.tangentDirArea.getLineDirection();
                ScriptoriumPoint startPoint = (ScriptoriumPoint)this.limitPoints.get(0);
                ScriptoriumPoint endPoint = (ScriptoriumPoint)this.limitPoints.get(1);
                this.frame.addParabolaAction(vertex, passingByPoint, diameterDirection, tangentDirection, startPoint, endPoint);
                this.dispose();
            }
            catch (InvalidValueException exc) {
                String message = exc.getMessage();
                JOptionPane.showMessageDialog(null, message);
            }
        } else {
            JOptionPane.showMessageDialog(null, "exactly two limit points should be selected");
        }
    }

    private ScriptoriumPoint getPassingByPoint(ScriptoriumPoint vertex) {
        ScriptoriumPoint passingByPoint = null;
        for (ScriptoriumPoint point : this.points) {
            if (point.equals(vertex)) continue;
            passingByPoint = point;
            break;
        }
        return passingByPoint;
    }
}

