/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ndraft.FieldsEnabler;
import org.homelinux.elabor.scriptorium.ndraft.PointCheckBox;
import org.homelinux.elabor.scriptorium.ndraft.PointsListener;
import org.homelinux.elabor.ui.UITools;

public abstract class LimitPointsActionDialog
extends JDialog
implements FieldsEnabler {
    private static final long serialVersionUID = 1L;
    protected List<ScriptoriumPoint> limitPoints;
    private List<PointCheckBox> checkBoxes;

    protected JScrollPane buildLimitsPanel(Iterable<ScriptoriumPoint> drawingPoints) {
        JPanel panel = new JPanel(new GridBagLayout());
        LineBorder lineBorder = new LineBorder(Color.black);
        TitledBorder titledBorder = new TitledBorder(lineBorder, "limit points");
        panel.setBorder(titledBorder);
        int position = 0;
        this.limitPoints = new ArrayList<ScriptoriumPoint>();
        this.checkBoxes = new ArrayList<PointCheckBox>();
        for (ScriptoriumPoint point : drawingPoints) {
            PointCheckBox checkBox = new PointCheckBox(point);
            PointsListener listener = new PointsListener(checkBox, this.limitPoints, this);
            checkBox.addActionListener(listener);
            this.checkBoxes.add(checkBox);
            UITools.addComponent(panel, checkBox, 1, position, 1, 1, 100, 1, 2, 2);
            ++position;
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        UITools.addComponent(this, scrollPane, 0, 0, 1, 1, 100, 100, 1, 2);
        return scrollPane;
    }

    @Override
    public void enableFields() {
        int count = this.limitPoints.size();
        for (PointCheckBox checkBox : this.checkBoxes) {
            ScriptoriumPoint point = checkBox.getPoint();
            boolean checkBoxSelected = this.limitPoints.contains(point);
            checkBox.setSelected(checkBoxSelected);
            boolean checkBoxEnabled = count < 2 || checkBoxSelected;
            checkBox.setEnabled(checkBoxEnabled);
        }
    }
}

