/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.ndraft.ActionConstraintListener;
import org.homelinux.elabor.scriptorium.ndraft.LabeledButton;
import org.homelinux.elabor.scriptorium.ndraft.LabeledButtonHandler;
import org.homelinux.elabor.scriptorium.ndraft.LabeledPoint;
import org.homelinux.elabor.scriptorium.ndraft.PointListener;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.services.Highlighter;
import org.homelinux.elabor.ui.UITools;

public class ChoosePointsArea
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Iterable<ComputeAction> NO_ACTIONS = Arrays.asList(new ComputeAction[0]);
    private static final Iterable<ScriptoriumPoint> NO_EXTRA_POINTS = Arrays.asList(new ScriptoriumPoint[0]);
    private final LabeledButtonHandler handler;

    public ChoosePointsArea(LabeledButtonHandler handler, String label, Iterable<? extends LabeledPoint> points, boolean scroll, boolean clearSelection) {
        this(handler, label, points, null, NO_ACTIONS, NO_EXTRA_POINTS, scroll, clearSelection);
    }

    public ChoosePointsArea(LabeledButtonHandler handler, String label, Iterable<? extends LabeledPoint> points, Iterable<ScriptoriumPoint> drawingPoints, boolean scroll, boolean clearSelection) {
        this(handler, label, points, null, NO_ACTIONS, drawingPoints, scroll, clearSelection);
    }

    public ChoosePointsArea(LabeledButtonHandler handler, String label, Iterable<? extends LabeledPoint> points, Map<ScriptoriumPoint, ComputeAction> pointsAction, Iterable<ComputeAction> drawingActions, Iterable<ScriptoriumPoint> drawingPoints, boolean scroll, boolean clearSelection) {
        this.handler = handler;
        LineBorder lineBorder = new LineBorder(Color.black);
        TitledBorder titledBorder = new TitledBorder(lineBorder, label);
        this.setBorder(titledBorder);
        Highlighter highlighter = new Highlighter(OntologyInitialiser.NULL);
        highlighter.setDrawingPoints(drawingPoints);
        highlighter.setDrawingActions(drawingActions);
        this.setLayout(new GridBagLayout());
        JPanel pointsPane = new JPanel();
        pointsPane.setLayout(new GridBagLayout());
        int row = 0;
        for (LabeledPoint labeledPoint : points) {
            ScriptoriumPoint point = labeledPoint.getPoint();
            ArrayList<JCheckBox> actionCheckBoxes = new ArrayList<JCheckBox>();
            for (ComputeAction action : drawingActions) {
                if (!action.isFixing(point)) continue;
                action.accept(highlighter);
                String text = highlighter.getText();
                JCheckBox actionCheckBox = new JCheckBox(text);
                actionCheckBox.setEnabled(true);
                ActionConstraintListener actionConstraintListener = new ActionConstraintListener(actionCheckBox, point, action, pointsAction);
                actionCheckBox.addItemListener(actionConstraintListener);
                actionCheckBoxes.add(actionCheckBox);
                int column = actionCheckBoxes.size();
                UITools.addComponent(pointsPane, actionCheckBox, column, row, 1, 1, 100, 10, 2, 2);
            }
            LabeledButton labButton = this.handler.create(labeledPoint);
            JToggleButton button = labButton.getButton();
            PointListener pointListener = new PointListener(button, actionCheckBoxes);
            button.addItemListener(pointListener);
            button.addItemListener(handler);
            UITools.addComponent(pointsPane, button, 0, row, 1, 1, 10, 10, 2, 2);
            ++row;
        }
        if (clearSelection) {
            JButton jButton = new JButton("clear selection");
            jButton.addActionListener(this);
            UITools.addComponent(pointsPane, jButton, 10, 0, 1, row - 1, 1, 1, 0, 2);
        }
        if (scroll) {
            JScrollPane jScrollPane = new JScrollPane(pointsPane);
            UITools.addComponent(this, jScrollPane, 0, 0, 1, 1, 100, 100, 1, 2);
        } else {
            UITools.addComponent(this, pointsPane, 0, 0, 1, 1, 100, 100, 1, 2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.handler.clearSelection();
    }
}

