/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.tongues;

import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.OntologyRefererPanel;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.scriptorium.services.Highlighter;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class TonguePanel
extends OntologyRefererPanel<Tongue> {
    private static final long serialVersionUID = 1L;
    private JLabel tongueLabel;
    private final Highlighter highlighter;

    public TonguePanel() {
        JScrollPane scrollPane = this.createScrollPane(0);
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        this.tongueLabel = UITools.setupLabel("", fontSize);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.tongueLabel, 0, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, scrollPane, 0, 1, 1, 1, 100, 100, 1, 2);
        EditionManager editionManager = EditionManager.getInstance();
        Ontology ontology = editionManager.getTonguesOntology();
        this.setOntology(ontology);
        this.highlighter = new Highlighter(OntologyInitialiser.TONGUES);
    }

    public void setup(GenericSelectionModel<Tongue> tongues, int index) {
        Tongue tongue = (Tongue)tongues.get(index);
        this.setReferer(tongue);
        this.highlighter.visit(tongue);
        String text = this.highlighter.getText();
        this.tongueLabel.setText(text);
        this.selectIndices();
    }
}

