/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.names;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.names.NameFrame;
import org.homelinux.elabor.ui.GenericSelectionModel;

public class NamesPanel
extends OldScriptoriumListArea<Name> {
    private static final long serialVersionUID = 1L;
    private NameFrame nameFrame;

    public NamesPanel() {
        super(false, true, true);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.NAMES);
        this.setCellRenderer(renderer);
        LineBorder border = new LineBorder(Color.black);
        this.setBorder(border);
        this.nameFrame = new NameFrame();
    }

    @Override
    public void setup(ScriptoriumDirector director, Name name) {
        Edition edition = director.getEdition();
        Content content = edition.getContent();
        List<Name> names = content.getNames();
        super.setup(director, names, name);
    }

    private void openNameFrame(int index) {
        GenericSelectionModel<Name> model = this.getModel();
        this.nameFrame.setup(model, index);
    }

    @Override
    public void addAction() {
    }

    @Override
    public void editAction(int index, Name name) {
        this.openNameFrame(index);
    }

    @Override
    public void remAction(int index, Name name) {
        GenericSelectionModel model = this.getModel();
        model.removeElementAt(index);
        this.getDirector().downgradeComponent(name);
    }

    @Override
    public boolean closing() {
        if (this.nameFrame != null) {
            this.nameFrame.dispose();
        }
        return super.closing();
    }
}

