/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.names;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.OntologyRefererPanel;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.scriptorium.services.Highlighter;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class NamePanel
extends OntologyRefererPanel<Name> {
    private static final long serialVersionUID = 1L;
    private JCheckBox incertoBox = new JCheckBox("incerto");
    private Name name;
    private JLabel nameLabel;
    private JTextField commentField;
    private JLabel commentLabel;
    private String commentString;
    private final Highlighter highlighter;

    public NamePanel() {
        JScrollPane scrollPane = this.createScrollPane(2);
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color color = preferences.getColor("text_fields_editable_bg_color");
        this.initLocale(preferences);
        this.nameLabel = UITools.setupLabel("", fontSize);
        this.commentLabel = UITools.setupLabel(this.commentString, fontSize);
        this.commentField = UITools.setupTextField(fontSize, color);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.nameLabel, 0, 0, 3, 1, 100, 1, 2, 2);
        UITools.addComponent(this, scrollPane, 0, 1, 3, 1, 100, 100, 1, 2);
        UITools.addComponent(this, this.commentLabel, 0, 2, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, this.commentField, 1, 2, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, this.incertoBox, 2, 2, 1, 1, 1, 100, 0, 2);
        EditionManager editionManager = EditionManager.getInstance();
        Ontology ontology = editionManager.getNamesOntology();
        this.setOntology(ontology);
        this.highlighter = new Highlighter(OntologyInitialiser.NAMES);
    }

    private void initLocale(Preferences preferences) {
        String locale = preferences.getProperty("locale");
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.commentString = catalog.translate("comment");
    }

    public void setup(GenericSelectionModel<Name> names, int index) {
        this.name = (Name)names.get(index);
        this.setReferer(this.name);
        this.highlighter.visit(this.name);
        String text = this.highlighter.getText();
        this.nameLabel.setText(text);
        this.selectIndices();
        String comment = this.name.getComment();
        this.commentField.setText(comment);
        boolean nameIncerto = this.name.isIncerto();
        this.incertoBox.setSelected(nameIncerto);
    }

    @Override
    public boolean okAction() {
        super.okAction();
        String comment = this.commentField.getText();
        this.name.setComment(comment);
        boolean nameIncerto = this.incertoBox.isSelected();
        this.name.setIncerto(nameIncerto);
        return true;
    }
}

