/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.metadata;

import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.DocumentType;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.Header;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReferenceInterface;
import org.homelinux.elabor.scriptorium.gui.DocumentTypeRenderer;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.EnumComboBox;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class MetadataPanel
extends ScriptoriumPanel<EditionComponent<?>> {
    static final long serialVersionUID = 1L;
    private Header header;
    private JTextField titleField;
    private JTextField docIdField;
    private JComboBox<?> authorField;
    private JCheckBox authorIncertoField;
    private JComboBox<?> authorPlaceField;
    private JComboBox<?> receiverField;
    private JCheckBox receiverIncertoField;
    private JComboBox<?> receiverPlaceField;
    private JDateChooser dateChooserField;
    private JTextField dateCommentField;
    private EnumComboBox<DocumentType> typeMenu;
    private JComboBox<?> publicationField;
    private String invalidDate;
    private String title;
    private String docId;
    private String author;
    private String authorPlace;
    private String receiver;
    private String receiverPlace;
    private String dateLabelString;
    private String dateComment;
    private String autographicyString;
    private String publicationString;
    private Ontology namesOntology;
    private DefaultGenericSelectionModel<OntologyClass> authorsList;
    private DefaultGenericSelectionModel<OntologyClass> receiversList;
    private Ontology placesOntology;
    private DefaultGenericSelectionModel<OntologyClass> authorPlacesList;
    private DefaultGenericSelectionModel<OntologyClass> receiverPlacesList;
    private Ontology publicationsOntology;
    private DefaultGenericSelectionModel<OntologyClass> publicationsList;

    public MetadataPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        EditionManager manager = EditionManager.getInstance();
        this.namesOntology = manager.getNamesOntology();
        List<OntologyClass> namesClasses = this.namesOntology.getClasses();
        namesClasses.add(0, null);
        this.authorsList = new DefaultGenericSelectionModel<OntologyClass>(namesClasses);
        this.receiversList = new DefaultGenericSelectionModel<OntologyClass>(namesClasses);
        this.placesOntology = manager.getPlacesOntology();
        List<OntologyClass> placesClasses = this.placesOntology.getClasses();
        placesClasses.add(0, null);
        this.authorPlacesList = new DefaultGenericSelectionModel<OntologyClass>(placesClasses);
        this.receiverPlacesList = new DefaultGenericSelectionModel<OntologyClass>(placesClasses);
        this.publicationsOntology = manager.getPublicationsOntology();
        List<OntologyClass> publicationsClasses = this.publicationsOntology.getClasses();
        publicationsClasses.add(0, null);
        this.publicationsList = new DefaultGenericSelectionModel<OntologyClass>(publicationsClasses);
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        this.titleField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel titleLabel = new JLabel(this.title, 4);
        this.docIdField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel docIdLabel = new JLabel(this.docId, 4);
        this.authorField = new JComboBox<OntologyClass>(this.authorsList);
        this.authorIncertoField = new JCheckBox("incerto");
        JLabel authorLabel = new JLabel(this.author, 4);
        this.authorPlaceField = new JComboBox<OntologyClass>(this.authorPlacesList);
        JLabel authorPlaceLabel = new JLabel(this.authorPlace, 4);
        this.receiverField = new JComboBox<OntologyClass>(this.receiversList);
        this.receiverIncertoField = new JCheckBox("incerto");
        JLabel receiverLabel = new JLabel(this.receiver, 4);
        this.receiverPlaceField = new JComboBox<OntologyClass>(this.receiverPlacesList);
        JLabel receiverPlaceLabel = new JLabel(this.receiverPlace, 4);
        this.dateChooserField = new JDateChooser();
        JLabel dateLabel = new JLabel(this.dateLabelString, 4);
        this.dateCommentField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel dateCommentLabel = new JLabel(this.dateComment, 4);
        JLabel autographicyLabel = new JLabel(this.autographicyString, 4);
        DocumentTypeRenderer autographicyTypeRenderer = new DocumentTypeRenderer();
        this.typeMenu = new EnumComboBox<DocumentType>(DocumentType.class, autographicyTypeRenderer);
        JLabel publicationLabel = new JLabel(this.publicationString, 4);
        this.publicationField = new JComboBox<OntologyClass>(this.publicationsList);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, titleLabel, 0, 0, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.titleField, 1, 0, 2, 1, 100, 100, 2, 2);
        UITools.addComponent(this, docIdLabel, 0, 1, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.docIdField, 1, 1, 2, 1, 100, 100, 2, 2);
        UITools.addComponent(this, authorLabel, 0, 2, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.authorField, 1, 2, 1, 1, 100, 100, 2, 2);
        UITools.addComponent(this, this.authorIncertoField, 2, 2, 1, 1, 10, 100, 0, 2);
        UITools.addComponent(this, authorPlaceLabel, 0, 3, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.authorPlaceField, 1, 3, 2, 1, 100, 100, 2, 2);
        UITools.addComponent(this, receiverLabel, 0, 4, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.receiverField, 1, 4, 1, 1, 100, 100, 2, 2);
        UITools.addComponent(this, this.receiverIncertoField, 2, 4, 1, 1, 10, 100, 0, 2);
        UITools.addComponent(this, receiverPlaceLabel, 0, 5, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.receiverPlaceField, 1, 5, 2, 1, 100, 100, 2, 2);
        UITools.addComponent(this, dateLabel, 0, 6, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, (Component)this.dateChooserField, 1, 6, 2, 1, 100, 100, 2, 2);
        UITools.addComponent(this, dateCommentLabel, 0, 7, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.dateCommentField, 1, 7, 2, 1, 100, 100, 2, 2);
        UITools.addComponent(this, autographicyLabel, 0, 8, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.typeMenu, 1, 8, 2, 1, 100, 100, 2, 2);
        UITools.addComponent(this, publicationLabel, 0, 9, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.publicationField, 1, 9, 2, 1, 100, 100, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName());
        this.title = catalog.translate("title");
        this.docId = catalog.translate("documentId");
        this.author = catalog.translate("author");
        this.authorPlace = catalog.translate("authorPlace");
        this.receiver = catalog.translate("receiver");
        this.receiverPlace = catalog.translate("receiverPlace");
        this.dateLabelString = catalog.translate("date");
        this.dateComment = catalog.translate("dateComment");
        this.invalidDate = catalog.translate("invalidDate");
        this.autographicyString = catalog.translate("autographicy");
        this.publicationString = catalog.translate("publication");
    }

    @Override
    public void setup(ScriptoriumDirector director) {
        Edition edition = director.getEdition();
        this.header = edition.getHeader();
        this.titleField.setText(this.header.getTitle());
        this.docIdField.setText(this.header.getIdentifier());
        this.authorField.setSelectedIndex(MetadataPanel.getPreSelectedOntologyIndex(this.header.getAuthor(), this.authorsList, this.namesOntology));
        boolean authorIncerto = this.header.isAuthorIncerto();
        this.authorIncertoField.setSelected(authorIncerto);
        this.authorPlaceField.setSelectedIndex(MetadataPanel.getPreSelectedOntologyIndex(this.header.getAuthorPlace(), this.authorPlacesList, this.placesOntology));
        this.receiverField.setSelectedIndex(MetadataPanel.getPreSelectedOntologyIndex(this.header.getReceiver(), this.receiversList, this.namesOntology));
        boolean receiverIncerto = this.header.isReceiverIncerto();
        this.receiverIncertoField.setSelected(receiverIncerto);
        this.receiverPlaceField.setSelectedIndex(MetadataPanel.getPreSelectedOntologyIndex(this.header.getReceiverPlace(), this.receiverPlacesList, this.placesOntology));
        this.dateChooserField.setDate(this.header.getDate());
        this.dateCommentField.setText(this.header.getDateComment());
        this.typeMenu.setSelectedItem((Object)this.header.getDocumentType());
        this.publicationField.setSelectedIndex(MetadataPanel.getPreSelectedOntologyIndex(this.header.getPublication(), this.publicationsList, this.publicationsOntology));
        super.setup(director);
    }

    private static int getPreSelectedOntologyIndex(OntologyReferenceInterface reference, GenericSelectionModel<OntologyClass> model, Ontology ontology) {
        int index = -1;
        if (reference != null) {
            OntologyClass oClass = ontology.getOntologyClass(reference);
            if (oClass != null) {
                int ii = 1;
                while (ii < model.getSize()) {
                    OntologyClass current = (OntologyClass)model.get(ii);
                    if (current.equals(oClass)) {
                        index = ii;
                    }
                    ++ii;
                }
            }
        } else if (model.getSize() > 0) {
            index = 0;
        }
        return index;
    }

    @Override
    public boolean okAction() {
        this.header.setTitle(this.titleField.getText());
        this.header.setIdentifier(this.docIdField.getText());
        this.setAuthor();
        boolean authIncerto = this.authorIncertoField.isSelected();
        boolean recIncerto = this.receiverIncertoField.isSelected();
        this.header.setAuthorIncerto(authIncerto);
        this.header.setReceiverIncerto(recIncerto);
        this.setAuthorPlace();
        this.setReceiver();
        this.setReceiverPlace();
        Date date = this.dateChooserField.getDate();
        if (date == null) {
            JOptionPane.showMessageDialog(null, this.invalidDate);
            this.header.removeDate();
        } else {
            this.header.setDate(date);
        }
        this.header.setDateComment(this.dateCommentField.getText());
        int selectedIndex = this.typeMenu.getSelectedIndex();
        DocumentType documentType = DocumentType.values()[selectedIndex];
        this.header.setDocumentType(documentType);
        this.setPublication();
        ScriptoriumDirector director = this.getDirector();
        director.updateSummaryPanel();
        director.valueChanged(this);
        return true;
    }

    private OntologyReference setOntologyId(OntologyClass selection) {
        OntologyReference reference = new OntologyReference(this.header);
        String id = selection.getId();
        reference.setOntologyId(id);
        return reference;
    }

    private void setAuthor() {
        OntologyClass selection = (OntologyClass)this.authorField.getSelectedItem();
        if (selection != null) {
            OntologyReference reference = this.setOntologyId(selection);
            this.header.setAuthor(reference);
        } else {
            this.header.removeAuthor();
        }
    }

    private void setAuthorPlace() {
        OntologyClass selection = (OntologyClass)this.authorPlaceField.getSelectedItem();
        if (selection != null) {
            OntologyReference reference = this.setOntologyId(selection);
            this.header.setAuthorPlace(reference);
        } else {
            this.header.removeAuthorPlace();
        }
    }

    private void setReceiver() {
        OntologyClass selection = (OntologyClass)this.receiverField.getSelectedItem();
        if (selection != null) {
            OntologyReference reference = this.setOntologyId(selection);
            this.header.setReceiver(reference);
        } else {
            this.header.removeReceiver();
        }
    }

    private void setReceiverPlace() {
        OntologyClass selection = (OntologyClass)this.receiverPlaceField.getSelectedItem();
        if (selection != null) {
            OntologyReference reference = this.setOntologyId(selection);
            this.header.setReceiverPlace(reference);
        } else {
            this.header.removeReceiverPlace();
        }
    }

    private void setPublication() {
        OntologyClass selection = (OntologyClass)this.publicationField.getSelectedItem();
        if (selection != null) {
            OntologyReference reference = this.setOntologyId(selection);
            this.header.setPublication(reference);
        } else {
            this.header.removePublication();
        }
    }
}

