/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.images;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.file.FileSystemTools;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Image;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class ImagePanel
extends ScriptoriumPanel<Image>
implements ActionListener {
    public static final long serialVersionUID = 1L;
    private Image image;
    private String imageFileNameString;
    private String fileChooseText;
    private String fileChooseTooltip;
    private String captionString;
    private JTextField imageFileName;
    private JButton fileChooseButton;
    private JTextField captionField;
    private JLabel captionLabel;
    private final EditionManager manager;

    public ImagePanel() {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        Color color = preferences.getColor("text_fields_editable_bg_color");
        int fieldFontSize = preferences.getInteger("text_fields_font_size");
        int labelFontSize = preferences.getInteger("label_font_size");
        Color bgColor = preferences.getColor("text_fields_protected_bg_color");
        this.imageFileName = UITools.setupTextField(fieldFontSize, bgColor);
        this.imageFileName.setBackground(preferences.getColor("text_fields_protected_bg_color"));
        this.imageFileName.setEditable(false);
        JLabel imageFileNameLabel = UITools.setupLabel(this.imageFileNameString, labelFontSize);
        this.fileChooseButton = UITools.setupButton(this.fileChooseText, this.fileChooseTooltip, this, true);
        this.captionLabel = UITools.setupLabel(this.captionString, labelFontSize);
        this.captionField = UITools.setupTextField(fieldFontSize, color);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, imageFileNameLabel, 0, 0, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.imageFileName, 1, 0, 1, 1, 100, 100, 2, 2);
        UITools.addComponent(this, this.fileChooseButton, 2, 0, 1, 1, 10, 100, 2, 2);
        UITools.addComponent(this, this.captionLabel, 0, 1, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.captionField, 1, 1, 2, 1, 100, 100, 2, 2);
        this.manager = EditionManager.getInstance();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.imageFileNameString = catalog.translate("imageFileName");
        this.fileChooseText = catalog.translate("fileChoose");
        this.fileChooseTooltip = catalog.translate("fileChooseTooltip");
        this.captionString = catalog.translate("description");
    }

    public void setup(GenericSelectionModel<Image> images, int index) {
        this.image = (Image)images.get(index);
        String caption = this.image.getCaption();
        this.captionField.setText(caption);
        URI uri = this.image.getUri();
        this.imageFileName.setText(uri.toString());
    }

    @Override
    public boolean okAction() {
        super.okAction();
        String caption = this.captionField.getText();
        this.image.setCaption(caption);
        String fileName = this.imageFileName.getText();
        if (!fileName.isEmpty()) {
            try {
                URI uri = new URI(fileName);
                this.image.setUri(uri);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        File imageFile = this.manager.chooseImageFile();
        if (imageFile != null) {
            Edition edition = this.image.getEdition();
            File defaultFolder = EditionManager.getImageDefaultFolder(edition);
            URI uri = FileSystemTools.getRelativeURI(defaultFolder, imageFile);
            this.imageFileName.setText(uri.toString());
        }
    }
}

