/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.styles;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSet;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.StylePanel;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.StylesManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;
import org.homelinux.elabor.ui.panel.ListArea;
import org.homelinux.elabor.ui.window.DefaultFrame;

public class StylesListArea
extends ListArea<ScriptoriumStyle> {
    private static final long serialVersionUID = 1L;
    private DefaultFrame<StylePanel, StylesManager> styleFrame;
    private StylesManager manager;
    private JButton copyButton;
    private String copyLabel;
    private String copyTooltip;

    public StylesListArea() {
        super(true, true, true);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.NULL);
        this.setCellRenderer(renderer);
        StylePanel stylePanel = new StylePanel();
        this.initLocale();
        this.styleFrame = new DefaultFrame(stylePanel);
        this.styleFrame.setSize(400, 500);
        this.copyButton = UITools.setupButton(this.copyLabel, this.copyTooltip, this, false);
        UITools.addComponent(this, this.copyButton, 2, 4, 1, 1, 0, 100, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        Preferences preferences = Preferences.getInstance();
        String locale = preferences.getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.copyLabel = catalog.translate("copy");
        this.copyTooltip = catalog.translate("copyTooltip");
    }

    public void setup(StylesManager manager) {
        this.manager = manager;
        GenericSelectionModel model = this.manager.getModel();
        this.setup(model);
    }

    @Override
    public void addAction() {
        this.manager.setSelectedItem(null);
        this.styleFrame.setup(this.manager);
    }

    @Override
    public void editAction(int index, ScriptoriumStyle style) {
        this.manager.setSelectedIndex(index);
        this.styleFrame.setup(this.manager);
    }

    @Override
    public void remAction(int index, ScriptoriumStyle style) {
        this.manager.removeItem(index);
        DrawingDirector drawingDirector = this.manager.getDrawingDirector();
        StyleSet styleset = drawingDirector.getStyleset();
        styleset.removeStyle(style);
    }

    public void copyAction() {
        DrawingDirector drawingDirector = this.manager.getDrawingDirector();
        ScriptoriumStyle selectedStyle = drawingDirector.getSelectedStyle();
        this.manager.setStylePrototype(selectedStyle);
        this.manager.setSelectedItem(null);
        this.styleFrame.setup(this.manager);
    }

    @Override
    public boolean closing() {
        this.styleFrame.dispose();
        return super.closing();
    }

    @Override
    public void valueChanged(boolean notify) {
        int[] selectedIndices = this.getSelectedIndices();
        int index = selectedIndices.length == 1 ? selectedIndices[0] : -1;
        this.copyButton.setEnabled(index >= 0);
        super.valueChanged(notify);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.copyButton) {
            this.copyAction();
        } else {
            super.actionPerformed(event);
        }
    }
}

