/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.points;

import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointFrame;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.panel.ListArea;

public class PointsArea
extends ListArea<ScriptoriumPoint> {
    private static final long serialVersionUID = 1L;
    private DrawingDirector director;
    private PointFrame pointFrame;

    public PointsArea(boolean showAddButton, boolean showEditButton, boolean showRemButton) {
        super(showAddButton, showEditButton, showRemButton);
    }

    public void setup(DrawingDirector drawingDirector) {
        this.director = drawingDirector;
        GenericSelectionModel<ScriptoriumPoint> pointsModel = this.director.getPointsModel();
        super.setup(pointsModel);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.NULL);
        this.setCellRenderer(renderer);
        this.pointFrame = new PointFrame();
    }

    private void openPointFrame(ScriptoriumPoint point) {
        this.pointFrame.setup(this.director, point);
    }

    @Override
    public void addAction() {
        this.openPointFrame(null);
    }

    @Override
    public void remAction(int index, ScriptoriumPoint point) {
        this.director.removePoint(point);
    }

    @Override
    public void editAction(int index, ScriptoriumPoint point) {
        this.openPointFrame(point);
    }

    @Override
    public boolean closing() {
        if (this.pointFrame != null) {
            this.pointFrame.dispose();
        }
        return super.closing();
    }
}

