/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.groups.keywords;

import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.GlyphGroup;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.keywords.KeywordsFrame;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.panel.ListArea;

public class GroupKeywordsArea
extends ListArea<OntologyReference> {
    private static final long serialVersionUID = 1L;
    private KeywordsFrame keywordsFrame = new KeywordsFrame();
    private GlyphGroup group;
    private GenericSelectionModel<OntologyReference> referencesModel;

    public GroupKeywordsArea() {
        super(true, false, true);
    }

    public void setup(GlyphGroup group) {
        this.group = group;
        List<OntologyReference> references = this.group.getOntologyReferences();
        this.referencesModel = new DefaultGenericSelectionModel<OntologyReference>(references);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.KEYWORDS);
        this.setCellRenderer(renderer);
        super.setup(this.referencesModel);
    }

    @Override
    public void addAction() {
        this.keywordsFrame.setup(this.group, this);
    }

    @Override
    public void editAction(int index, OntologyReference item) {
    }

    @Override
    public void remAction(int index, OntologyReference item) {
        this.referencesModel.removeElementAt(index);
        this.group.removeChild(item);
    }
}

