/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.itools.DefaultPanel;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class ExportableAreaPanel
extends ScriptoriumPanel<EditionComponent<?>> {
    private static final long serialVersionUID = 1L;
    private String llxLabelString;
    private String llyLabelString;
    private String widthLabelString;
    private String heightLabelString;
    private JTextField llxField;
    private JTextField llyField;
    private JTextField widthField;
    private JTextField heightField;
    private DrawingDirector director;

    public ExportableAreaPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        JLabel llxLabel = new JLabel(this.llxLabelString, 4);
        this.llxField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel llyLabel = new JLabel(this.llyLabelString, 4);
        this.llyField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel widthLabel = new JLabel(this.widthLabelString, 4);
        this.widthField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel heightLabel = new JLabel(this.heightLabelString, 4);
        this.heightField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, llxLabel, 0, 0, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.llxField, 1, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, llyLabel, 0, 1, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.llyField, 1, 1, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, widthLabel, 0, 2, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.widthField, 1, 2, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, heightLabel, 0, 3, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.heightField, 1, 3, 1, 1, 100, 1, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.llxLabelString = catalog.translate("llxLabel");
        this.llyLabelString = catalog.translate("llyLabel");
        this.widthLabelString = catalog.translate("widthLabel");
        this.heightLabelString = catalog.translate("heightLabel");
    }

    public void setup(DrawingDirector director) {
        this.director = director;
        int leftX = this.director.getOriginX();
        int ulY = this.director.getOriginY();
        int width = this.director.getWidth();
        int height = this.director.getHeight();
        int llY = ulY - height;
        this.llxField.setText(String.valueOf(leftX));
        this.llyField.setText(String.valueOf(llY));
        this.heightField.setText(String.valueOf(height));
        this.widthField.setText(String.valueOf(width));
    }

    @Override
    public boolean okAction() {
        boolean ok;
        DefaultPanel.CheckIntField checkLLX = this.checkIntField(this.llxField.getText(), this.llxLabelString);
        DefaultPanel.CheckIntField checkLLY = this.checkIntField(this.llyField.getText(), this.llyLabelString);
        DefaultPanel.CheckIntField checkWidth = this.checkIntField(this.widthField.getText(), this.widthLabelString);
        DefaultPanel.CheckIntField checkHeight = this.checkIntField(this.heightField.getText(), this.heightLabelString);
        boolean bl = ok = checkLLX.ok && checkLLY.ok && checkHeight.ok && checkWidth.ok;
        if (ok) {
            int leftX = checkLLX.value;
            int llY = checkLLY.value;
            int width = checkWidth.value;
            int height = checkHeight.value;
            int ulY = llY + height;
            this.director.setExportableArea(leftX, ulY, width, height);
        }
        return ok;
    }
}

