/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.Color;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.Style;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.ColorSet;

class ColorManager {
    ColorManager() {
    }

    public static ColorSet getPointColorSet(ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints, List<ScriptoriumPoint> selectedPoints, List<ScriptoriumShape> selectedShapes, boolean gui, boolean showInvisibles, Style style, boolean original) {
        Preferences preferences = Preferences.getInstance();
        Color pointSelectedColor = preferences.getColor("points_selected_color", original);
        Color pointReferenceSelectedColor = preferences.getColor("points_reference_selected_color", original);
        Color pointHiddenColor = preferences.getColor("points_hidden_color", original);
        ColorSet colorSet = new ColorSet();
        if (gui) {
            boolean selected = selectedPoints.contains(point);
            if (selected) {
                colorSet.setColor(pointSelectedColor);
                colorSet.setLabelColor(pointSelectedColor);
                colorSet.setAnchorColor(pointSelectedColor);
            } else {
                boolean shapeSelected = ShapeAdapter.belongsToSelectedShapes(point, drawingPoints, selectedShapes);
                if (shapeSelected) {
                    colorSet.setColor(pointReferenceSelectedColor);
                    colorSet.setLabelColor(pointReferenceSelectedColor);
                } else if (point.isVisible()) {
                    ColorManager.setColorsFromStyle(style, colorSet, original);
                } else if (showInvisibles) {
                    colorSet.setColor(pointHiddenColor);
                    colorSet.setLabelColor(pointHiddenColor);
                } else {
                    colorSet.setLabelColor(style.getLabelColor());
                }
            }
        } else if (point.isVisible()) {
            ColorManager.setColorsFromStyle(style, colorSet, original);
        } else {
            colorSet.setLabelColor(style.getLabelColor());
        }
        return colorSet;
    }

    public static ColorSet getShapeColorSet(AbstractShape<?> innerShape, boolean selected, boolean gui, boolean showInvisibles, Style style, boolean original) {
        Preferences preferences = Preferences.getInstance();
        Color lineSelectedColor = preferences.getColor("lines_selected_color", original);
        Color lineHiddenColor = preferences.getColor("lines_hidden_color", original);
        ColorSet colorSet = new ColorSet();
        if (gui && selected) {
            colorSet.setColor(lineSelectedColor);
            colorSet.setLabelColor(lineSelectedColor);
            colorSet.setAnchorColor(lineSelectedColor);
            Color fillColor = style.getFillColor(original);
            if (fillColor.getAlpha() > 0) {
                colorSet.setFillColor(lineSelectedColor);
            } else {
                colorSet.setFillColor(fillColor);
            }
        } else if (innerShape.isVisible()) {
            ColorManager.setColorsFromStyle(style, colorSet, original);
        } else if (gui && showInvisibles) {
            colorSet.setColor(lineHiddenColor);
            colorSet.setLabelColor(lineHiddenColor);
        } else {
            Color labelColor = style.getLabelColor();
            colorSet.setLabelColor(labelColor);
        }
        return colorSet;
    }

    private static void setColorsFromStyle(Style style, ColorSet colorSet, boolean original) {
        Color elementColor = style.getElementColor(original);
        colorSet.setColor(elementColor);
        Color labelColor = style.getLabelColor();
        colorSet.setLabelColor(labelColor);
        Color fillColor = style.getFillColor(original);
        colorSet.setFillColor(fillColor);
    }
}

