/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.datetokens;

import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.services.Highlighter;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class DateTokenPanel
extends ScriptoriumPanel<DateToken> {
    private static final long serialVersionUID = 1L;
    private GenericSelectionModel<DateToken> dateTokens;
    private DateToken dateToken;
    private int index;
    private JLabel dateTokenLabel;
    private JDateChooser dateField;
    private String invalidDate;

    public DateTokenPanel() {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        this.dateTokenLabel = UITools.setupLabel("", preferences.getInteger("text_fields_font_size"));
        this.dateField = new JDateChooser();
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.dateTokenLabel, 0, 0, 1, 1, 10, 10, 2, 2);
        UITools.addComponent(this, (Component)this.dateField, 0, 1, 1, 1, 1, 1, 1, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName());
        this.invalidDate = catalog.translate("invalidDate");
    }

    public void setup(GenericSelectionModel<DateToken> dateTokens, int index) {
        this.dateTokens = dateTokens;
        this.index = index;
        this.dateToken = (DateToken)dateTokens.get(index);
        Highlighter highlighter = new Highlighter(OntologyInitialiser.NULL);
        highlighter.visit(this.dateToken);
        this.dateTokenLabel.setText(highlighter.getText());
        Date date = this.dateToken.getDate();
        this.dateField.setDate(date);
    }

    @Override
    public boolean okAction() {
        Date date = this.dateField.getDate();
        if (date == null) {
            JOptionPane.showMessageDialog(null, this.invalidDate);
            this.dateToken.removeDate();
        } else {
            this.dateToken.setDate(this.dateField.getDate());
        }
        this.dateTokens.set(this.index, this.dateToken);
        return true;
    }
}

