/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.file.ExtensionFileFilter;
import org.homelinux.elabor.scriptorium.ecomponents.Reference;
import org.homelinux.elabor.scriptorium.ecomponents.References;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class ReferencePanel
extends ScriptoriumPanel<Reference>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private References references;
    private DefaultGenericSelectionModel<Reference> referencesModel;
    private int index;
    private JTextField idField;
    private JTextField nameField;
    private JTextField filenameField;
    private JButton fileChooseButton;
    private Reference reference;
    private String idString;
    private String nameString;
    private String filenameString;
    private String fileChooseText;
    private String fileChooseTooltip;
    private String xmlFilterTooltip;

    public ReferencePanel() {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        int fieldFontSize = preferences.getInteger("text_fields_font_size");
        int labelFontSize = preferences.getInteger("label_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        Color protectedBgColor = preferences.getColor("text_fields_protected_bg_color");
        this.idField = new JTextField(8);
        this.idField.setFont(this.idField.getFont().deriveFont(fieldFontSize));
        this.idField.setBackground(editableBgColor);
        this.idField.setEditable(true);
        this.nameField = new JTextField();
        this.nameField.setFont(this.nameField.getFont().deriveFont(fieldFontSize));
        this.nameField.setBackground(editableBgColor);
        this.nameField.setEditable(true);
        this.filenameField = new JTextField();
        this.filenameField.setFont(this.filenameField.getFont().deriveFont(fieldFontSize));
        this.filenameField.setBackground(protectedBgColor);
        this.filenameField.setEditable(false);
        JLabel refIdLabel = UITools.setupLabel(this.idString, labelFontSize);
        JLabel refNameLabel = UITools.setupLabel(this.nameString, labelFontSize);
        JLabel refFileNameLabel = UITools.setupLabel(this.filenameString, labelFontSize);
        this.fileChooseButton = UITools.setupButton(this.fileChooseText, this.fileChooseTooltip, this, true);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, refIdLabel, 0, 0, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, refNameLabel, 0, 1, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, refFileNameLabel, 0, 2, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.idField, 1, 0, 2, 1, 10, 1, 2, 2);
        UITools.addComponent(this, this.nameField, 1, 1, 2, 1, 10, 1, 2, 2);
        UITools.addComponent(this, this.filenameField, 1, 2, 1, 1, 10, 1, 2, 2);
        UITools.addComponent(this, this.fileChooseButton, 2, 2, 1, 1, 1, 1, 0, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.idString = catalog.translate("referenceId");
        this.nameString = catalog.translate("referenceName");
        this.filenameString = catalog.translate("referenceFileName");
        this.fileChooseText = catalog.translate("fileChoose");
        this.fileChooseTooltip = catalog.translate("fileChooseTooltip");
        this.xmlFilterTooltip = catalog.translate("xmlFilterTooltip");
    }

    public void setup(References references, DefaultGenericSelectionModel<Reference> model, int index) {
        this.references = references;
        this.referencesModel = model;
        this.index = index;
        this.reference = index >= 0 ? this.referencesModel.get(index).makeCopy(new Reference()) : new Reference(this.references);
        this.idField.setText(this.reference.getId());
        this.nameField.setText(this.reference.getName());
        this.filenameField.setText(this.reference.getFileName());
    }

    @Override
    public boolean okAction() {
        this.reference.setId(this.idField.getText());
        this.reference.setName(this.nameField.getText());
        this.reference.setFileName(this.filenameField.getText());
        if (this.index < 0) {
            this.referencesModel.append(this.reference);
            this.references.addReference(this.reference);
        } else {
            this.references.replaceReference(this.referencesModel.get(this.index), this.reference);
            this.referencesModel.set(this.index, this.reference);
        }
        return super.okAction();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter(".xml", this.xmlFilterTooltip);
        chooser.setFileFilter(filter);
        if (chooser.showOpenDialog(null) == 0) {
            this.filenameField.setText(chooser.getSelectedFile().getPath());
        }
    }
}

