/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.InvalidPropertiesFormatException;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.DefaultStroke;
import org.homelinux.elabor.ui.UIConstants;

public class Preferences
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULTS_FILE_NAME = "scriptorium.defaults";
    private static final String PREFERENCES_FILE_NAME = "scriptorium.preferences";
    private static final String PREFERENCES_COMMENT = "Scriptorium preferences";
    private static final String PREFERENCES_ENCODING = "UTF-8";
    public static final String TEXT_FIELDS_PROTECTED_BG_COLOR = "text_fields_protected_bg_color";
    public static final String TEXT_FIELDS_EDITABLE_BG_COLOR = "text_fields_editable_bg_color";
    public static final String TEXT_FIELDS_FONT_SIZE = "text_fields_font_size";
    public static final String LISTS_BG_COLOR = "lists_bg_color";
    public static final String BNODE_URL_NAME = "bnode_url";
    public static final String LOCALE = "locale";
    public static final String COLLECTION_ID = "collection_id";
    public static final String METADATA_SUMMARY = "metadata_summary";
    public static final String NAME_COLOR = "name_color";
    public static final String DATE_TOKEN_COLOR = "date_token_color";
    public static final String MATHCONCEPT_COLOR = "math_concept_color";
    public static final String EXPUNCTIO_COLOR = "expunctio_color";
    public static final String CRUX_COLOR = "crux_color";
    public static final String ENUNCIATIO_COLOR = "enunciatio_color";
    public static final String FORMULA_COLOR = "formula_color";
    public static final String VARIANT_COLOR = "variant_color";
    public static final String READING_COLOR = "reading_color";
    public static final String CITATION_COLOR = "citation_color";
    public static final String POINTS_UNSELECTED_COLOR = "points_unselected_color";
    public static final String POINTS_REFERENCE_SELECTED_COLOR = "points_reference_selected_color";
    public static final String POINTS_SELECTED_COLOR = "points_selected_color";
    public static final String POINTS_PREVIEW_COLOR = "points_preview_color";
    public static final String POINTS_HIDDEN_COLOR = "points_hidden_color";
    public static final String LINES_UNSELECTED_COLOR = "lines_unselected_color";
    public static final String LINES_SELECTED_COLOR = "lines_selected_color";
    public static final String BORDER_SHAPE_COLOR = "border_shape_color";
    public static final String FREEHAND_SHAPE_COLOR = "freehand_shape_color";
    public static final String LINES_HIDDEN_COLOR = "lines_hidden_color";
    public static final String LINES_COMPUTED_COLOR = "lines_computed_color";
    public static final String DRAG_PREVIEW_COLOR = "drag_preview_color";
    public static final String POINTS_SIZE = "points_size";
    public static final String POINT_SELECTION_DISTANCE = "point_selection_distance";
    public static final String LINE_SELECTION_DISTANCE = "line_selection_distance";
    public static final String DRAG_SHORTEST_DISTANCE = "drag_shortest_distance";
    public static final String DRAG_SHORTEST_TIME = "drag_shortest_time";
    public static final String LINES_WIDTH = "lines_width";
    public static final String FONT_SIZE = "font_size";
    public static final String LABEL_COLOR = "label_color";
    public static final String LABEL_FONT_SIZE = "label_font_size";
    public static final String DRAWING_WIDTH = "drawing_width";
    public static final String DRAWING_HEIGHT = "drawing_height";
    public static final String SHAPE_ATTRIBUTE_PREFIX = "shape_attribute";
    public static final String NAME_SUFFIX = "_name_";
    public static final String LABEL_SUFFIX = "_label_";
    public static final String LINES_NAME_COLOR = "lines_name_color";
    public static final String LINES_COMPLETE_COLOR = "lines_complete_color";
    public static final String LINES_UNCOMPLETE_COLOR = "lines_uncomplete_color";
    public static final String LINES_UNCOMPLETE_BGCOLOR = "lines_uncomplete_bgcolor";
    public static final String DESCRIPTIONS_COLOR = "descriptions_color";
    public static final String STROKE_ATTRIBUTE_PREFIX = "stroke_";
    public static final String GRID_SIZE = "grid_size";
    public static final String THICK_LINE = "thick_line";
    public static final String FONT_NAME = "font";
    public static final String MAGNETIC = "snap_to_grid";
    public static final String SHOW_GRID = "show_grid";
    public static final String SHOW_INVISIBLES = "show_invisibles";
    public static final String SHOW_LABELS = "show_labels";
    public static final String SHOW_BACKGROUND_IMAGE = "show_background_image";
    public static final String TRANSPARENCY = "shadows";
    public static final String SHADING = "shading";
    public static final String AREA_LINE_WIDTH = "area_line_width";
    public static final String AREA_LINE_STROKE = "area_line_stroke";
    public static final String AREA_LINE_COLOR = "area_line_color";
    public static final String VALIDATE = "validate";
    public static final String LABEL_ANCHOR_DIAGONAL = "label_anchor_diagonal";
    public static final String PLACE_COLOR = "place_color";
    public static final String WORK_COLOR = "work_color";
    public static final String NAMES_ONTOLOGY = "names_ontology";
    public static final String CONSPECTUS_PREFIX = "conspectus_";
    private String invalidFormatString;
    private URL defaultsURL;
    private static Preferences instance;

    protected Preferences() {
        Locale defaultLocale = Locale.getDefault();
        this.setProperty(LOCALE, defaultLocale.toString());
        this.defaultsURL = this.getClass().getClassLoader().getResource(DEFAULTS_FILE_NAME);
        this.reload(null);
    }

    public void reload(File currentFolder) {
        try {
            URLConnection defaultsConnection = this.defaultsURL.openConnection();
            Throwable throwable = null;
            Object var4_7 = null;
            try (InputStream defaultsInputStream = defaultsConnection.getInputStream();){
                this.loadProperties(defaultsInputStream);
                File stdPrefFile = new File(PREFERENCES_FILE_NAME);
                this.loadProperties(stdPrefFile);
                if (currentFolder != null) {
                    File specPrefFile = new File(currentFolder, PREFERENCES_FILE_NAME);
                    this.loadProperties(specPrefFile);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            UIConstants uiConstants = UIConstants.getInstance();
            String message = e.getMessage();
            String errorMessage = String.valueOf(uiConstants.ioErrorString) + ": " + message;
            JOptionPane.showMessageDialog(null, errorMessage, uiConstants.errorString, 0);
        }
    }

    public void loadProperties(File file) throws IOException {
        if (file.exists()) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.loadProperties(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void loadProperties(InputStream inputStream) throws IOException {
        try {
            this.loadFromXML(inputStream);
        }
        catch (InvalidPropertiesFormatException exc) {
            UIConstants uiConstants = UIConstants.getInstance();
            JOptionPane.showMessageDialog(null, this.invalidFormatString, uiConstants.errorString, 0);
        }
    }

    public static synchronized Preferences getInstance() {
        return instance;
    }

    public static synchronized Preferences newInstance() {
        if (instance == null) {
            instance = new Preferences();
        }
        return instance;
    }

    public void save() {
        File preferences_file = new File(PREFERENCES_FILE_NAME);
        try {
            preferences_file.createNewFile();
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream preferences_output_stream = new FileOutputStream(preferences_file);){
                this.storeToXML((OutputStream)preferences_output_stream, PREFERENCES_COMMENT, PREFERENCES_ENCODING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(null, exc.getMessage(), UIConstants.getInstance().errorString, 0);
        }
    }

    public File getFile(String name) {
        String pathName = this.getProperty(name);
        return new File(pathName);
    }

    public String getString(String name) {
        return this.getProperty(name);
    }

    public boolean getBoolean(String name) {
        boolean value;
        String stringValue = this.getProperty(name);
        try {
            value = Boolean.parseBoolean(stringValue);
        }
        catch (NumberFormatException exc) {
            value = false;
        }
        return value;
    }

    public int getInteger(String name) {
        int value = 0;
        String stringValue = this.getProperty(name);
        try {
            value = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException exc) {
            value = 0;
        }
        return value;
    }

    public double getDouble(String name) {
        double value = 0.0;
        String stringValue = this.getProperty(name);
        try {
            value = Double.parseDouble(stringValue);
        }
        catch (NumberFormatException exc) {
            value = 0.0;
        }
        return value;
    }

    public float getFloat(String name) {
        float value = 0.0f;
        String stringValue = this.getProperty(name);
        try {
            value = Float.parseFloat(stringValue);
        }
        catch (Exception exc) {
            value = 0.0f;
        }
        return value;
    }

    public Color getColor(String colorName) {
        return this.getColor(colorName, false);
    }

    public Color getColor(String colorName, boolean original) {
        Color color = Color.BLACK;
        String colorString = this.getProperty(String.valueOf(colorName) + (original ? "_orig" : ""));
        if (original && colorString == null) {
            colorString = this.getProperty(colorName);
        }
        if (colorString != null) {
            try {
                String[] color_components = colorString.split(":", 3);
                int red = Integer.parseInt(color_components[0]);
                int green = Integer.parseInt(color_components[1]);
                int blue = Integer.parseInt(color_components[2]);
                color = new Color(red, green, blue);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return color;
    }

    public DefaultStroke getStroke(String name) {
        String pattern = this.getString(name);
        DefaultStroke stroke = pattern == null ? null : new DefaultStroke(pattern);
        return stroke;
    }
}

