/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.exports;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionStreamer;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.exports.ExportProcessor;
import org.homelinux.elabor.scriptorium.exports.OwlEditionVisitor;
import org.homelinux.elabor.scriptorium.services.EditionManager;

class OwlExportProcessor
implements ExportProcessor {
    private PrintWriter writer;
    private OwlEditionVisitor visitor;
    private List<Edition> editions;
    private final EditionManager manager = EditionManager.getInstance();
    private final Ontology editionsOntology = this.manager.getEditionsOntology();

    OwlExportProcessor() {
        this.visitor = new OwlEditionVisitor();
    }

    @Override
    public void processEdition(Edition edition, EditionStreamer streamer) {
        this.processEdition(edition);
    }

    @Override
    public void processEdition(Edition edition) {
        this.editions.add(edition);
    }

    private void printEditions() {
        for (Edition edition : this.editions) {
            edition.accept(this.visitor);
        }
    }

    private void printEditionsOntology() {
        List<OntologyClass> editionsClasses = this.editionsOntology.getClasses();
        for (OntologyClass editionsClass : editionsClasses) {
            String id = editionsClass.getId();
            this.writer.println("<owl:Class rdf:ID=\"" + id + "\">" + "<rdfs:comment>" + editionsClass + "</rdfs:comment>" + "</owl:Class>");
        }
    }

    @Override
    public void startProcess(File file) throws FileNotFoundException, UnsupportedEncodingException {
        this.writer = new PrintWriter(file, "utf-8");
        this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns=\"http://www.owl-ontologies.com/unnamed.owl#\" xmlns:owl=\"http://www.w3.org/2002/07/owl#\" xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" xml:base=\"http://www.owl-ontologies.com/unnamed.owl\">");
        this.writer.println("<owl:Ontology rdf:about=\"\"/>");
        this.visitor.setWriter(this.writer);
        this.editions = new ArrayList<Edition>();
    }

    @Override
    public void endProcess() {
        this.printEditions();
        this.printEditionsOntology();
        this.writer.println("</rdf:RDF>");
        this.writer.close();
    }
}

