/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.visitors;

import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.Annotation;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Comment;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Crux;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.Enunciatio;
import org.homelinux.elabor.scriptorium.ecomponents.Expunctio;
import org.homelinux.elabor.scriptorium.ecomponents.Folium;
import org.homelinux.elabor.scriptorium.ecomponents.Formula;
import org.homelinux.elabor.scriptorium.ecomponents.Image;
import org.homelinux.elabor.scriptorium.ecomponents.Integratio;
import org.homelinux.elabor.scriptorium.ecomponents.ListItem;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.ecomponents.Quadratus;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.Rectangulus;
import org.homelinux.elabor.scriptorium.ecomponents.Text;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.NullEditionVisitor;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineDirectionAction;

public class NodeOffsetFinder
extends NullEditionVisitor {
    private EditionComponent<?> target;
    private int offset;
    private boolean found;

    private boolean found(EditionComponent<?> node) {
        return this.target.getElement() == node.getElement();
    }

    private void defaultVisit(EditionComponent<?> node) {
        if (this.found(node)) {
            this.found = true;
        } else {
            List<EditionComponent<?>> children = node.getChildrenForTextView();
            if (children != null) {
                for (EditionComponent<?> child : children) {
                    child.accept(this);
                    if (this.found) break;
                }
            }
        }
    }

    private void nonValuedTokenVisit(EditionComponent<?> node) {
        if (this.found(node)) {
            this.found = true;
        } else {
            ++this.offset;
        }
    }

    public void setTarget(EditionComponent<?> node) {
        this.offset = 0;
        this.target = node;
        this.found = false;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public void visit(Edition edition) {
        Content content = edition.getContent();
        content.accept(this);
    }

    @Override
    public void visit(Content content) {
        this.defaultVisit(content);
    }

    private void visitDelimitedComponent(EditionComponent<?> component) {
        ++this.offset;
        this.defaultVisit(component);
        if (!this.found) {
            ++this.offset;
        }
    }

    @Override
    public void visit(ListItem list_item) {
        this.offset += 2;
        this.defaultVisit(list_item);
    }

    @Override
    public void visit(Expunctio expunctio) {
        this.visitDelimitedComponent(expunctio);
    }

    @Override
    public void visit(Crux crux) {
        this.visitDelimitedComponent(crux);
    }

    @Override
    public void visit(Integratio integratio) {
        this.nonValuedTokenVisit(integratio);
    }

    @Override
    public void visit(Variant variant) {
        this.visitDelimitedComponent(variant);
    }

    @Override
    public void visit(VariantItem variant_item) {
        this.defaultVisit(variant_item);
    }

    @Override
    public void visit(Reading reading) {
        this.defaultVisit(reading);
    }

    @Override
    public void visit(Name name) {
        this.defaultVisit(name);
    }

    @Override
    public void visit(Place place) {
        this.defaultVisit(place);
    }

    @Override
    public void visit(Tongue tongue) {
        this.defaultVisit(tongue);
    }

    @Override
    public void visit(MathConcept mathConcept) {
        this.defaultVisit(mathConcept);
    }

    @Override
    public void visit(DateToken date) {
        this.defaultVisit(date);
    }

    @Override
    public void visit(Enunciatio enunciatio) {
        this.defaultVisit(enunciatio);
    }

    @Override
    public void visit(Formula formula) {
        this.defaultVisit(formula);
    }

    @Override
    public void visit(Citation citation) {
        this.defaultVisit(citation);
    }

    @Override
    public void visit(Text text) {
        if (this.found(text)) {
            this.found = true;
        } else {
            this.offset += text.getTextLength();
        }
    }

    @Override
    public void visit(Drawing drawing) {
        this.nonValuedTokenVisit(drawing);
    }

    @Override
    public void visit(Unit unit) {
        this.nonValuedTokenVisit(unit);
    }

    @Override
    public void visit(TextPart part) {
        this.nonValuedTokenVisit(part);
    }

    @Override
    public void visit(Folium folium) {
        ++this.offset;
        this.defaultVisit(folium);
    }

    @Override
    public void visit(Quadratus quadratus) {
        ++this.offset;
        this.defaultVisit(quadratus);
    }

    @Override
    public void visit(Rectangulus rectangulus) {
        ++this.offset;
        this.defaultVisit(rectangulus);
    }

    @Override
    public void visit(Comment comment) {
        this.nonValuedTokenVisit(comment);
    }

    @Override
    public void visit(Annotation annotation) {
        this.nonValuedTokenVisit(annotation);
    }

    @Override
    public void visit(Work work) {
        this.defaultVisit(work);
    }

    @Override
    public void visit(Image image) {
        this.nonValuedTokenVisit(image);
    }

    @Override
    public void visit(StraightLineAction straightLineAction) {
    }

    @Override
    public void visit(StraightLineDirectionAction straightLineDirectionAction) {
    }
}

