/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.styles;

import java.awt.Color;
import java.io.Serializable;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionLeaf;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.Style;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSet;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.DefaultStroke;
import org.homelinux.elabor.ui.ColorHelper;
import org.w3c.dom.Element;

public class ScriptoriumStyle
extends EditionLeaf<ScriptoriumStyle>
implements ComponentFactory<ScriptoriumStyle>,
Style,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String STYLE_NAME = "style_name";
    private static final String STYLE_WIDTH = "style_width";
    private static final String STYLE_DASH = "style_dash";
    private static final String STYLE_COLOR = "style_color";
    private static final String STYLE_POINT_SIZE = "style_point_size";
    private static final String STYLE_LABEL_COLOR = "style_label_color";
    private static final String STYLE_LABEL_FONT_SIZE = "style_label_font_size";
    private static final String STYLE_FONT = "style_font";
    private static final String STYLE_FILL_COLOR = "style_fill_color";

    public ScriptoriumStyle() {
    }

    public ScriptoriumStyle(Element element) {
        super(element);
    }

    public ScriptoriumStyle(StyleSet styleSet) {
        super(styleSet);
    }

    public void setName(String name) {
        this.setStringAttribute(STYLE_NAME, name);
    }

    @Override
    public String getName() {
        return this.getStringAttribute(STYLE_NAME);
    }

    public void setElementColor(Color color, boolean original) {
        this.setColorAttribute(STYLE_COLOR, color, original);
    }

    @Override
    public Color getElementColor(boolean orginal) {
        return this.getColor(STYLE_COLOR, Color.BLACK, orginal);
    }

    public void setStroke(DefaultStroke stroke) {
        this.setFloatAttribute(STYLE_WIDTH, stroke.getLineWidth());
        this.setStringAttribute(STYLE_DASH, stroke.getPattern());
    }

    @Override
    public DefaultStroke getStroke() {
        String pattern = this.getStringAttribute(STYLE_DASH);
        float width = this.getFloatAttribute(STYLE_WIDTH);
        return new DefaultStroke(width, pattern);
    }

    public void setPointSize(int pointSize) {
        this.setIntAttribute(STYLE_POINT_SIZE, pointSize);
    }

    @Override
    public int getPointSize() {
        return this.getIntAttribute(STYLE_POINT_SIZE);
    }

    public void setLabelColor(Color color) {
        this.setColorAttribute(STYLE_LABEL_COLOR, color, false);
    }

    @Override
    public Color getLabelColor() {
        return this.getColor(STYLE_LABEL_COLOR, Color.BLACK, false);
    }

    private Color getColor(String attrName, Color defaultColor, boolean original) {
        Color color = this.getColorAttribute(attrName, original);
        if (color == null) {
            color = defaultColor;
        }
        return color;
    }

    public void setFillColor(Color color, boolean original) {
        this.setColorAttribute(STYLE_FILL_COLOR, color, original);
    }

    @Override
    public Color getFillColor(boolean original) {
        return this.getColor(STYLE_FILL_COLOR, ColorHelper.NULL_COLOR, original);
    }

    public void setLabelFontSize(int labelFontSize) {
        this.setIntAttribute(STYLE_LABEL_FONT_SIZE, labelFontSize);
    }

    @Override
    public int getLabelFontSize() {
        return this.getIntAttribute(STYLE_LABEL_FONT_SIZE);
    }

    public void setFontName(String fontName) {
        this.setStringAttribute(STYLE_FONT, fontName);
    }

    @Override
    public String getFontName() {
        return this.getStringAttribute(STYLE_FONT);
    }

    @Override
    public String getElementName() {
        return "style";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ScriptoriumStyle make(Element element) {
        return new ScriptoriumStyle(element);
    }
}

