/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentIdentifier;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.AbstractPointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.LabelAnchorType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeReference;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.extractors.KeyExtractor;

public class ShapeAdapter {
    public static Shape getShape(AbstractShape<?> abstractShape, Iterable<ScriptoriumPoint> drawingPoints, boolean original) {
        Shape shape = null;
        if (abstractShape.isComplete()) {
            List<ScriptoriumPoint> shapePoints = ShapeAdapter.getShapePoints(abstractShape, drawingPoints);
            Point2D[] p = ShapeAdapter.getPoints2D(shapePoints, original);
            shape = abstractShape.getShape(p);
        }
        return shape;
    }

    public static <T extends AbstractPointReference<T>> T getPoint(AbstractPointReference<?> reference, Iterable<T> drawingPoints) {
        int id = reference.getId();
        return (T)((AbstractPointReference)ShapeAdapter.getReferredItem(id, drawingPoints));
    }

    public static <T extends ComponentIdentifier> T getReferredItem(int reference, Iterable<T> items) {
        ComponentIdentifier item = null;
        for (ComponentIdentifier current : items) {
            if (reference != current.getId()) continue;
            item = current;
        }
        return (T)item;
    }

    public static ComputeAction getReferredAction(int reference, Iterable<ComputeAction> drawingActions) {
        return ShapeAdapter.getReferredItem(reference, drawingActions);
    }

    public static List<ScriptoriumPoint> getShapePoints(AbstractShape<?> abstractShape, Iterable<ScriptoriumPoint> drawingPoints) {
        List<PointReference> pointsReferences = abstractShape.getPointReferences();
        return ShapeAdapter.getReferredPoints(pointsReferences, drawingPoints);
    }

    public static <T extends AbstractPointReference<T>> List<T> getReferredPoints(List<? extends AbstractPointReference<?>> pointsReferences, Iterable<T> drawingPoints) {
        ArrayList<T> points = new ArrayList<T>();
        for (AbstractPointReference<?> reference : pointsReferences) {
            T point = ShapeAdapter.getPoint(reference, drawingPoints);
            if (point == null) continue;
            points.add(point);
        }
        return points;
    }

    public static List<ScriptoriumShape> getReferredShapes(Iterable<ShapeReference> shapeReferences, Iterable<ScriptoriumShape> drawingShapes) {
        return ShapeAdapter.getReferredItems(shapeReferences, drawingShapes);
    }

    private static <T extends ComponentIdentifier> List<T> getReferredItems(Iterable<? extends ComponentIdentifier> references, Iterable<T> referrables) {
        ArrayList<T> referredList = new ArrayList<T>();
        for (ComponentIdentifier componentIdentifier : references) {
            T referred = ShapeAdapter.getReferred(componentIdentifier, referrables);
            if (referred == null) continue;
            referredList.add(referred);
        }
        return referredList;
    }

    private static <T extends ComponentIdentifier> T getReferred(ComponentIdentifier reference, Iterable<T> referrables) {
        ComponentIdentifier referred = null;
        for (ComponentIdentifier referrable : referrables) {
            if (reference.getId() != referrable.getId()) continue;
            referred = referrable;
        }
        return (T)referred;
    }

    public static Point2D[] getPoints2D(List<ScriptoriumPoint> shapePoints) {
        return ShapeAdapter.getPoints2D(shapePoints, false);
    }

    public static Point2D[] getPoints2D(List<ScriptoriumPoint> shapePoints, boolean original) {
        Point2D[] points2D = new Point2D[shapePoints.size()];
        int index = 0;
        for (ScriptoriumPoint point : shapePoints) {
            points2D[index] = point.getPoint2D(original);
            ++index;
        }
        return points2D;
    }

    public static Point2D getAnchorPosition(AbstractShape<?> shape, Iterable<ScriptoriumPoint> drawingPoints) {
        LabelAnchorType anchorType = shape.getLabelAnchorType();
        Point2D anchorP = ShapeAdapter.getAnchorPosition(anchorType, shape, drawingPoints);
        return anchorP;
    }

    public static Point2D getAnchorPosition(LabelAnchorType anchorType, AbstractShape<?> shape, Iterable<ScriptoriumPoint> drawingPoints) {
        List<ScriptoriumPoint> shapePoints = ShapeAdapter.getShapePoints(shape, drawingPoints);
        return anchorType.getAnchorPosition(shapePoints);
    }

    public static boolean belongsToSelectedShapes(ScriptoriumPoint point, Iterable<ScriptoriumPoint> points, Iterable<ScriptoriumShape> selectedShapes) {
        boolean selected = false;
        for (ScriptoriumShape shape : selectedShapes) {
            AbstractShape<?> innerShape = shape.getShape();
            List<ScriptoriumPoint> shapePoints = ShapeAdapter.getShapePoints(innerShape, points);
            if (!shapePoints.contains(point)) continue;
            selected = true;
            break;
        }
        return selected;
    }

    public static List<PointReference> getReferences(List<ScriptoriumPoint> points) {
        KeyExtractor<PointReference, ScriptoriumPoint> extractor = point -> point.getReference();
        return StructuresHelper.buildList(points, extractor);
    }

    public static ComputeAction findConicAction(ScriptoriumPoint point, Iterable<ComputeAction> actions) {
        ComputeAction conicAction = null;
        for (ComputeAction action : actions) {
            conicAction = ShapeAdapter.findConicAction(point, action, actions);
            if (conicAction != null) break;
        }
        return conicAction;
    }

    private static ComputeAction findConicAction(ScriptoriumPoint point, ComputeAction action, Iterable<ComputeAction> actions) {
        AbstractAction<?> inner = action.getAction();
        ComputeAction conicAction = null;
        conicAction = inner.isConicBy(point) ? action : inner.getTargetConic(point, actions);
        return conicAction;
    }
}

