/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeVisitor;
import org.homelinux.elabor.tools.MessageCatalog;
import org.w3c.dom.Element;

public class Ellipse
extends AbstractShape<Ellipse>
implements ComponentFactory<Ellipse> {
    private String focusAString;
    private String focusBString;
    private String pointString;
    private String[] pointNames;

    public Ellipse() {
        this.initLocale();
    }

    public Ellipse(Element element) {
        super(element);
        this.initLocale();
    }

    public Ellipse(ScriptoriumShape parent, EditionListener listener) {
        super(parent, listener);
        this.initLocale();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName());
        this.focusAString = catalog.translate("focusA");
        this.focusBString = catalog.translate("focusB");
        this.pointString = catalog.translate("point");
        this.pointNames = new String[]{this.focusAString, this.focusBString, this.pointString};
    }

    @Override
    public int getNeededNumberOfPoints() {
        return this.pointNames.length;
    }

    @Override
    public String getPointName(int position) {
        return this.pointNames[position];
    }

    @Override
    public Shape getShape(Point2D[] points) {
        Point2D f1 = points[0];
        Point2D f2 = points[1];
        Point2D p = points[2];
        double semiMajor = Ellipse.getSemiMajor(f1, f2, p);
        double semiInterFocus = Ellipse.getSemiInterfocus(f1, f2);
        double semiMinor = Ellipse.getSemiMinor(semiMajor, semiInterFocus);
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        ellipse.setFrameFromCenter(0.0, 0.0, semiMajor, semiMinor);
        double x = (points[0].getX() + points[1].getX()) / 2.0;
        double y = (points[0].getY() + points[1].getY()) / 2.0;
        double cos = (points[1].getX() - points[0].getX()) / points[0].distance(points[1]);
        double sin = (points[1].getY() - points[0].getY()) / points[0].distance(points[1]);
        AffineTransform t = new AffineTransform();
        t.setTransform(cos, sin, -sin, cos, x, y);
        return t.createTransformedShape(ellipse);
    }

    public static double getSemiMajor(Point2D f1, Point2D f2, Point2D p) {
        double semiMajor = (f1.distance(p) + f2.distance(p)) / 2.0;
        return semiMajor;
    }

    public static double getSemiInterfocus(Point2D f1, Point2D f2) {
        return f1.distance(f2) / 2.0;
    }

    public static double getSemiMinor(double semiMajor, double semiInterFocus) {
        return Math.sqrt(Math.pow(semiMajor, 2.0) - Math.pow(semiInterFocus, 2.0));
    }

    @Override
    public String getElementName() {
        return ComponentType.ELLIPSE.getName();
    }

    @Override
    public Ellipse make(Element element) {
        return new Ellipse(element);
    }

    @Override
    public void accept(ShapeVisitor visitor) {
        visitor.visit(this);
    }
}

