/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes;

import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeVisitor;
import org.homelinux.elabor.tools.MessageCatalog;
import org.w3c.dom.Element;

public class Arc
extends AbstractShape<Arc>
implements ComponentFactory<Arc> {
    private String startString;
    private String endString;
    private String pointString;
    private String[] pointNames;
    private double xc;
    private double yc;
    private double r;

    public Arc() {
        this.initLocale();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName());
        this.startString = catalog.translate("start");
        this.endString = catalog.translate("end");
        this.pointString = catalog.translate("point");
        this.pointNames = new String[]{this.startString, this.endString, this.pointString};
    }

    public double getX() {
        return this.xc;
    }

    public double getY() {
        return this.yc;
    }

    public double getRadius() {
        return this.r;
    }

    public Arc(Element element) {
        super(element);
        this.initLocale();
    }

    public Arc(ScriptoriumShape parent, EditionListener listener) {
        super(parent, listener);
        this.initLocale();
    }

    @Override
    public int getNeededNumberOfPoints() {
        return this.pointNames.length;
    }

    @Override
    public String getPointName(int position) {
        return this.pointNames[position];
    }

    @Override
    public Shape getShape(Point2D[] p) {
        Shape shape;
        try {
            Array2DRowRealMatrix A = new Array2DRowRealMatrix(3, 3);
            ArrayRealVector B = new ArrayRealVector(3);
            int i = 0;
            while (i < 3) {
                A.setEntry(i, 0, p[i].getX());
                A.setEntry(i, 1, p[i].getY());
                A.setEntry(i, 2, 1.0);
                B.setEntry(i, -Math.pow(p[i].getX(), 2.0) - Math.pow(p[i].getY(), 2.0));
                ++i;
            }
            DecompositionSolver solver = new LUDecomposition((RealMatrix)A).getSolver();
            RealVector X = solver.solve((RealVector)B);
            this.xc = -X.getEntry(0) / 2.0;
            this.yc = -X.getEntry(1) / 2.0;
            this.r = Math.sqrt(Math.pow(this.xc, 2.0) + Math.pow(this.yc, 2.0) - X.getEntry(2));
            Arc2D.Double arc = new Arc2D.Double();
            double angSt = 0.0;
            double angExt = 0.0;
            arc.setArcByCenter(this.xc, this.yc, this.r, angSt, angExt, 0);
            arc.setAngles(p[0], p[1]);
            shape = arc;
        }
        catch (RuntimeException exc) {
            shape = new Line2D.Double(Math.max(p[0].getX(), Math.max(p[1].getX(), p[2].getX())), Math.max(p[0].getY(), Math.max(p[1].getY(), p[2].getY())), Math.min(p[0].getX(), Math.min(p[1].getX(), p[2].getX())), Math.min(p[0].getY(), Math.min(p[1].getY(), p[2].getY())));
            this.xc = 0.0;
            this.yc = 0.0;
            this.r = 0.0;
        }
        return shape;
    }

    @Override
    public String getElementName() {
        return ComponentType.ARC.getName();
    }

    @Override
    public Arc make(Element element) {
        return new Arc(element);
    }

    @Override
    public void accept(ShapeVisitor visitor) {
        visitor.visit(this);
    }
}

