/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class EditionValidator {
    private static final String EDITION_SCHEMA = "edition.xsd";
    private static EditionValidator instance;
    private Validator validator;

    public static synchronized EditionValidator getInstance() {
        if (instance == null) {
            instance = new EditionValidator();
        }
        return instance;
    }

    private EditionValidator() {
        SchemaFactory schema_factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = this.getClass().getClassLoader().getResource(EDITION_SCHEMA);
        try {
            Schema schema = schema_factory.newSchema(schemaUrl);
            this.validator = schema.newValidator();
        }
        catch (SAXException exc) {
            throw new RuntimeException(exc);
        }
    }

    public void validate(Source source) {
        try {
            this.validator.validate(source);
        }
        catch (IOException | SAXException exc) {
            throw new RuntimeException(exc);
        }
    }

    public void validate(EditionComponent<?> component) {
        Document document = component.getDocument();
        DOMSource source = new DOMSource(document);
        this.validate(source);
    }
}

