/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.pdf;

import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import java.util.Map;
import org.homelinux.elabor.pdf.FieldType;
import org.homelinux.elabor.pdf.NodeHandler;
import org.homelinux.elabor.pdf.NodeHelper;
import org.homelinux.elabor.pdf.TypedField;
import org.w3c.dom.Node;

public class ParamHandler
implements NodeHandler {
    private Font font;

    public ParamHandler(Font font) {
        Font.FontFamily family = font.getFamily();
        float size = font.getSize();
        this.font = new Font(family, size, 1);
        this.font.setColor(153, 51, 0);
    }

    @Override
    public void handle(Paragraph paragraph, Map<String, Object> valuesMap, Map<String, ? extends TypedField> fieldsMap, Node node) {
        String name = NodeHelper.getName(node);
        FieldType type = NodeHelper.getType(fieldsMap, name);
        Object value = valuesMap.get(name);
        String text = type.getFormattedValue(value);
        Phrase phrase = new Phrase();
        phrase.setFont(this.font);
        phrase.add(text);
        paragraph.add((Element)phrase);
    }
}

