/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.itools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.CharRotation;
import org.homelinux.elabor.scriptorium.gui.Preferences;

public class CartesianGraphics {
    private Graphics2D graphics;
    private AffineTransform transform = new AffineTransform();
    private double magnification = 1.0;
    private double rotation = 0.0;
    private double xTranslation = 0.0;
    private double yTranslation = 0.0;

    public void setGraphics(Graphics2D g) {
        this.graphics = g;
        this.transform.setTransform(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
    }

    public void setOrigin(double xDisplacement, double yDisplacement) {
        this.transform.setTransform(1.0, 0.0, 0.0, -1.0, xDisplacement, yDisplacement);
    }

    public void setCustomTransform(double magnification, double rotation, double xTranslation, double yTranslation) {
        this.magnification = magnification;
        this.rotation = rotation;
        this.xTranslation = xTranslation;
        this.yTranslation = yTranslation;
    }

    public void drawGrid(Dimension dimension) {
        int startY;
        int startX;
        Point2D topLeft = this.getDefaultPosition(new Point2D.Double(0.0, 0.0));
        Point2D botRight = this.getDefaultPosition(new Point2D.Double(dimension.getWidth(), dimension.getHeight()));
        Preferences prefs = Preferences.getInstance();
        int gridSize = prefs.getInteger("grid_size");
        int v = startX = (int)(topLeft.getX() / (double)gridSize);
        while ((double)(v * gridSize) < botRight.getX()) {
            this.setGridLineColor(v);
            Point2D.Double p = new Point2D.Double(v * gridSize, topLeft.getY());
            Point2D.Double q = new Point2D.Double(v * gridSize, botRight.getY());
            this.drawGridLine(p, q);
            ++v;
        }
        int o = startY = (int)(topLeft.getY() / (double)gridSize);
        while ((double)(o * gridSize) > botRight.getY()) {
            this.setGridLineColor(o);
            Point2D.Double p = new Point2D.Double(topLeft.getX(), o * gridSize);
            Point2D.Double q = new Point2D.Double(botRight.getX(), o * gridSize);
            this.drawGridLine(p, q);
            --o;
        }
    }

    private Point2D getDefaultPosition(Point2D point) {
        Point2D p;
        try {
            p = this.transform.inverseTransform(point, null);
        }
        catch (NoninvertibleTransformException exc) {
            p = null;
        }
        return p;
    }

    private void setGridLineColor(int lineNumber) {
        Preferences prefs = Preferences.getInstance();
        int thickLine = prefs.getInteger("thick_line");
        if (thickLine == 0) {
            this.setColor(Color.lightGray);
        } else if (lineNumber % thickLine == 0) {
            this.setColor(Color.darkGray);
        } else {
            this.setColor(Color.lightGray);
        }
    }

    private void drawGridLine(Point2D start, Point2D end) {
        AffineTransform t = this.transform;
        Point2D p = t.transform(start, null);
        Point2D q = t.transform(end, null);
        this.graphics.drawLine((int)p.getX(), (int)p.getY(), (int)q.getX(), (int)q.getY());
    }

    public void drawRectangle(int ulX, int ulY, int width, int height) {
        Point2D point = this.getTransformPoint2D(ulX, ulY);
        int pointX = (int)point.getX();
        int pointY = (int)point.getY();
        this.graphics.drawRect(pointX, pointY, width, height);
    }

    public Point2D getTransformPoint2D(double ulX, double ulY) {
        AffineTransform t = this.getDrawingTransform();
        Point2D.Double point = new Point2D.Double(ulX, ulY);
        Point2D p = t.transform(point, null);
        return p;
    }

    private AffineTransform getDrawingTransform() {
        return this.transform;
    }

    private AffineTransform getImageTransform(Image image) {
        AffineTransform rotomag = new AffineTransform();
        AffineTransform drawingTransform = this.getDrawingTransform();
        Point2D O = drawingTransform.transform(new Point2D.Double(0.0, 0.0), null);
        double w = image.getWidth(null);
        double h = image.getHeight(null);
        rotomag.translate(O.getX(), O.getY() - h * this.magnification);
        rotomag.translate(this.xTranslation, -this.yTranslation);
        rotomag.scale(this.magnification, this.magnification);
        rotomag.rotate(-this.rotation * Math.PI / 180.0, w / 2.0, h / 2.0);
        return rotomag;
    }

    public void drawShape(Shape shape, boolean shading, Color shapeFillColor) {
        Color color;
        AffineTransform t = this.getDrawingTransform();
        Shape transformedShape = t.createTransformedShape(shape);
        this.graphics.draw(transformedShape);
        int alpha = shapeFillColor.getAlpha();
        if (alpha != 0) {
            color = shapeFillColor;
        } else if (shading) {
            Color gColor = this.graphics.getColor();
            int red = gColor.getRed();
            int green = gColor.getGreen();
            int blue = gColor.getBlue();
            Preferences prefs = Preferences.getInstance();
            alpha = prefs.getInteger("shadows");
            color = new Color(red, green, blue, alpha);
        } else {
            color = null;
        }
        if (color != null) {
            this.graphics.setColor(color);
            this.graphics.fill(transformedShape);
        }
    }

    public void drawString(Point2D point, String label, double theta, CharRotation charRotation, double charInterspace) {
        AffineTransform t = this.getDrawingTransform();
        Point2D p = t.transform(point, null);
        double x = p.getX();
        double y = p.getY();
        charRotation.drawString(this.graphics, label, x, y, theta, charInterspace);
    }

    public Point2D getPoint(Point2D point) {
        Point2D p;
        try {
            AffineTransform drawingTransform = this.getDrawingTransform();
            p = drawingTransform.inverseTransform(point, null);
        }
        catch (NoninvertibleTransformException exc) {
            p = null;
        }
        return p;
    }

    public void setColor(Color color) {
        this.graphics.setColor(color);
    }

    public void setFont(Font font) {
        this.graphics.setFont(font);
    }

    public void setStroke(Stroke stroke) {
        this.graphics.setStroke(stroke);
    }

    public void fillOval(Point2D point, int width, int height) {
        AffineTransform t = this.getDrawingTransform();
        Point2D p = t.transform(point, null);
        this.graphics.fillOval((int)p.getX() - width / 2, (int)p.getY() - height / 2, width, height);
    }

    public void drawAnchor(Point2D point, int diagonal) {
        AffineTransform t = this.getDrawingTransform();
        Point2D p = t.transform(point, null);
        int x = (int)p.getX();
        int y = (int)p.getY();
        int delta = diagonal / 2;
        this.graphics.drawLine(x - delta, y + delta, x + delta, y - delta);
        this.graphics.drawLine(x - delta, y - delta, x + delta, y + delta);
    }

    public void drawImage(Image image) {
        AffineTransform t = this.getImageTransform(image);
        this.graphics.drawImage(image, t, null);
    }

    public FontMetrics getFontMetrics() {
        Font font = this.graphics.getFont();
        return this.graphics.getFontMetrics(font);
    }
}

