/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db.generic;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.db.ConnectionHandler;
import org.homelinux.elabor.db.DataAccessException;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.QueryTemplate;
import org.homelinux.elabor.db.RecordCreator;
import org.homelinux.elabor.db.generic.GenericRecordCreator;

public class GenericDao {
    private ConnectionHandler manager;

    public GenericDao(ConnectionHandler manager) {
        this.manager = manager;
    }

    public <T> List<T> getRecords(QueryTemplate query, Class<T> recordClass) {
        RecordCreator<T> creator = this.buildCreator(recordClass);
        return this.getRecords(query, creator);
    }

    public <T> List<T> getRecords(QueryTemplate query, RecordCreator<T> creator) {
        return this.getRecords(query.toString(), creator);
    }

    private <T> List<T> getRecords(String query, RecordCreator<T> creator) {
        ArrayList<T> list = new ArrayList<T>();
        Connection connection = this.manager.getConnection();
        try (Statement statement = connection.createStatement(1004, 1008);
             ResultSet rs = this.manager.executeQuery(query, statement);){
            while (rs.next()) {
                T record = creator.createRecord(rs);
                list.add(record);
            }
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        return list;
    }

    public <T> T getRecord(QueryTemplate query, Class<T> recordClass) throws DataNotFoundException {
        RecordCreator<T> creator = this.buildCreator(recordClass);
        return this.getRecord(query, creator);
    }

    public <T> T getRecord(QueryTemplate query, RecordCreator<T> creator) throws DataNotFoundException {
        return this.getRecord(query.toString(), creator, "", "", true);
    }

    private <T> T getRecord(String query, RecordCreator<T> creator, String tableName, String key, boolean checkUnique) throws DataNotFoundException {
        T record;
        block16: {
            Connection connection = this.manager.getConnection();
            try (Statement statement = connection.createStatement(1004, 1008);
                 ResultSet rs = this.manager.executeQuery(query, statement);){
                if (rs.next()) {
                    if (!checkUnique || rs.isLast()) {
                        record = creator.createRecord(rs);
                        break block16;
                    }
                    throw new DataAccessException("record non unico: " + query);
                }
                throw new DataNotFoundException(tableName, key);
            }
            catch (SQLException e) {
                throw new DataAccessException(e);
            }
        }
        return record;
    }

    public <R> RecordCreator<R> buildCreator(Class<R> recordClass) {
        GenericRecordCreator<R> creator;
        try {
            creator = new GenericRecordCreator<R>(this, recordClass);
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
        return creator;
    }

    public String identity(String value) {
        return value;
    }

    @Deprecated
    public static URL toUrl(String value) {
        URL url;
        try {
            url = new URL(value);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        return url;
    }
}

