/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.calendar;

import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.calendar.MonthIterable;
import org.homelinux.elabor.calendar.MonthIterator;

public class Quadrimestre {
    private final int anno;
    private final Month firstMonth;

    public Quadrimestre(int anno, Month firstMonth) {
        this.anno = anno;
        this.firstMonth = firstMonth;
    }

    public int getAnno() {
        return this.anno;
    }

    public Month getFirstMonth() {
        return this.firstMonth;
    }

    public MonthIterable getMonthIterable() {
        Month lastMonth = this.getLastMonth();
        return new MonthIterable(this.firstMonth, lastMonth, this.anno);
    }

    public MonthIterator getMonthIterator() {
        Month lastMonth = this.getLastMonth();
        return new MonthIterator(this.firstMonth, lastMonth, this.anno);
    }

    public Month getLastMonth() {
        return Month.valueOf(this.firstMonth.getIndex() + 3);
    }

    public Quadrimestre previousAnno() {
        return new Quadrimestre(this.anno - 1, this.firstMonth);
    }

    public static Month getStart(Month mese) {
        return Month.values()[mese.ordinal() / 4 * 4];
    }

    public Date getStartDate() {
        return CalendarTools.getDate(this.anno, this.firstMonth, 1);
    }
}

