/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.tools.Observer;

public class DirectoryListener
extends Thread {
    private List<Observer> observers;
    private File directory;
    private long sleep;
    private String createdString;
    private String notCreatedString;
    private String startingString;

    public DirectoryListener(String path, long sleep) {
        this.initLocale();
        this.observers = new ArrayList<Observer>();
        this.createDirectory(path);
        this.sleep = sleep;
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName());
        this.createdString = catalog.translate("created");
        this.notCreatedString = catalog.translate("not_created");
        this.startingString = catalog.translate("starting");
    }

    public void createDirectory(String path) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        this.directory = new File(path);
        if (!this.directory.exists()) {
            if (this.directory.mkdirs()) {
                logger.info(this.createdString + path);
            } else {
                logger.log(Level.SEVERE, this.notCreatedString + path);
            }
        }
    }

    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public synchronized void start() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.info(this.startingString + this.directory.getName());
        super.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                DirectoryListener.sleep(this.sleep);
                this.getFilesContent();
            }
        }
        catch (InterruptedException exc) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, exc.getMessage());
            Thread.currentThread().interrupt();
            return;
        }
    }

    private boolean getFilesContent() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        File[] files = this.directory.listFiles();
        boolean ok = true;
        for (File file : files) {
            logger.log(Level.INFO, file.toString());
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.notifyObserver(fileInputStream);
                fileInputStream.close();
                ok = ok && file.delete();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage());
            }
        }
        return ok;
    }

    private void notifyObserver(InputStream inputStream) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.info("notify observers");
        for (Observer observer : this.observers) {
            observer.notify(inputStream);
        }
    }
}

