/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.thread;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.thread.Work;
import org.homelinux.elabor.thread.Worker;
import org.homelinux.elabor.thread.WorkerFactory;

public class WorkersPool<D extends Closeable> {
    private final List<Worker<D>> free;
    private final List<Worker<D>> busy;
    private final int sleep;

    public WorkersPool(int size, int sleep, WorkerFactory<D> factory) throws IOException {
        this.sleep = sleep;
        this.free = new ArrayList<Worker<D>>();
        this.busy = new ArrayList<Worker<D>>();
        for (int id = 0; id < size; ++id) {
            Worker<D> worker = factory.buildWorker(id, this);
            this.free.add(worker);
        }
    }

    public void execute(Work<D> work) {
        Worker<D> worker = this.getWorker();
        worker.execute(work);
    }

    private Worker<D> getWorker() {
        Worker<D> worker;
        while ((worker = this.get()) == null) {
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.put(worker);
        return worker;
    }

    private synchronized Worker<D> get() {
        return this.free.isEmpty() ? null : this.free.remove(0);
    }

    private synchronized void put(Worker<D> worker) {
        this.busy.add(worker);
    }

    public synchronized void finish(Worker<D> worker) {
        this.busy.remove(worker);
        this.free.add(worker);
    }

    public synchronized Worker<D> getFirstBusy() {
        return this.busy.isEmpty() ? null : this.busy.get(0);
    }

    private void waitEnd() {
        Worker<D> worker;
        while ((worker = this.getFirstBusy()) != null) {
            try {
                worker.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void close() {
        this.waitEnd();
        for (Worker<D> worker : this.free) {
            try {
                worker.close();
            }
            catch (IOException exc) {
                Logger logger = Logger.getAnonymousLogger();
                logger.log(Level.INFO, "an exception occurred while closing aworker", exc);
            }
        }
    }
}

