/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.thread;

import java.io.Closeable;
import java.io.IOException;
import org.homelinux.elabor.thread.Work;
import org.homelinux.elabor.thread.WorkThread;
import org.homelinux.elabor.thread.WorkersPool;

public class Worker<D extends Closeable> {
    private final int id;
    private final WorkersPool<D> pool;
    private final D data;
    private WorkThread<D> workThread;

    public Worker(int id, WorkersPool<D> pool, D data) {
        this.id = id;
        this.pool = pool;
        this.data = data;
    }

    public int getId() {
        return this.id;
    }

    public void execute(Work<D> work) {
        this.workThread = new WorkThread<D>(this, work, this.data);
        this.workThread.start();
    }

    public void finish() {
        this.pool.finish(this);
    }

    public void close() throws IOException {
        this.data.close();
    }

    public void join() throws InterruptedException {
        this.workThread.join();
    }
}

