/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.structures.listmap;

import java.util.List;
import java.util.Map;
import org.homelinux.elabor.structures.UnfoldedIterable;
import org.homelinux.elabor.structures.classifier.StoreClassifier;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.ListMapStore;

public class BasicListMap<K, V>
extends StoreClassifier<K, V, List<V>>
implements ListMap<K, V> {
    private final ListMapStore<K, V> store;

    public BasicListMap() {
        this(new ListMapStore());
    }

    public BasicListMap(ListMapStore<K, V> store) {
        super(store);
        this.store = store;
    }

    @Override
    public List<V> get(K key) {
        return (List)this.getStore().get(key);
    }

    @Override
    public Iterable<V> iterable() {
        return new UnfoldedIterable(this);
    }

    @Override
    public void put(K key, List<V> values) {
        this.store.put(key, values);
    }

    @Override
    public void addAll(List<V> values, KeyExtractor<K, V> extractor) {
        for (V value : values) {
            K key = extractor.getKey(value);
            if (key == null) continue;
            this.add(key, value);
        }
    }

    @Override
    public void addAll(ListMap<K, V> items) {
        for (Map.Entry entry : items.entrySet()) {
            Object key = entry.getKey();
            List values = (List)entry.getValue();
            this.put(key, values);
        }
    }
}

