/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.services;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.homelinux.elabor.scriptorium.services.AbstractTextSearcher;
import org.homelinux.elabor.scriptorium.services.BackwardTextSearcher;
import org.homelinux.elabor.scriptorium.services.CaseInsensitiveDecorator;
import org.homelinux.elabor.scriptorium.services.ForwardTextSearcher;
import org.homelinux.elabor.scriptorium.services.TextSearcher;
import org.homelinux.elabor.scriptorium.services.WholeWordDecorator;
import org.homelinux.elabor.scriptorium.services.WrapSearchDecorator;

public class Finder {
    private Document document;
    private Directions direction;
    private boolean case_sensitive;
    private boolean wrap_search;
    private boolean whole_word;
    private TextSearcher searcher;
    private int last_position;
    private String last_search;

    public Finder(Document document) {
        this.document = document;
        this.reset();
    }

    public void reset() {
        this.setDirection(Directions.FORWARD);
        this.setCaseSensitive(true);
        this.setWrapSearch(false);
        this.setWholeWord(false);
        this.setLastPosition(-1);
        this.setLastSearch("");
    }

    public void setDirection(Directions direction) {
        this.direction = direction;
    }

    public boolean searchForward() {
        boolean result = false;
        if (this.direction == Directions.FORWARD) {
            result = true;
        }
        return result;
    }

    public void setCaseSensitive(boolean sensitiveness) {
        this.case_sensitive = sensitiveness;
    }

    public boolean isCaseSensitive() {
        return this.case_sensitive;
    }

    public void setWrapSearch(boolean wrap_search) {
        this.wrap_search = wrap_search;
    }

    public boolean wrapSearch() {
        return this.wrap_search;
    }

    public void setWholeWord(boolean whole_word) {
        this.whole_word = whole_word;
    }

    public boolean wholeWord() {
        return this.whole_word;
    }

    public int getLastPosition() {
        return this.last_position;
    }

    public void setLastPosition(int position) {
        this.last_position = position;
    }

    public String getLastSearch() {
        return this.last_search;
    }

    public void setLastSearch(String search) {
        this.last_search = search;
    }

    private static String getText(Document document) {
        String text = "";
        try {
            text = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return text;
    }

    private TextSearcher setupSearcher() {
        AbstractTextSearcher newSearcher = null;
        newSearcher = this.direction == Directions.FORWARD ? new ForwardTextSearcher() : new BackwardTextSearcher();
        if (this.wrapSearch()) {
            newSearcher = new WrapSearchDecorator(newSearcher);
        }
        if (!this.isCaseSensitive()) {
            newSearcher = new CaseInsensitiveDecorator(newSearcher);
        }
        if (this.wholeWord()) {
            newSearcher = new WholeWordDecorator(newSearcher);
        }
        return newSearcher;
    }

    public int find(String match) {
        this.searcher = this.setupSearcher();
        String text = Finder.getText(this.document);
        int offset = this.getLastPosition();
        if (offset < 0) {
            offset = this.searcher.getStartPosition(text);
        }
        int result = this.searcher.search(text, match, offset);
        this.setLastPosition(result);
        this.setLastSearch(match);
        return result;
    }

    public static enum Directions {
        FORWARD,
        BACKWARD;

    }
}

