/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.scriptorium.ndraft.DirectionHandler;
import org.homelinux.elabor.scriptorium.ndraft.LineDirection;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractStraightLineAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.w3c.dom.Element;

public final class StraightLineDirectionAction
extends AbstractStraightLineAction<StraightLineDirectionAction>
implements DirectionHandler {
    private static final String DY = "dy";
    private static final String DX = "dx";
    private static final String FIXED_POINT = "fixed_point";
    private static final String FIRST_POINT = "first_point";
    private static final String SECOND_POINT = "second_point";

    public StraightLineDirectionAction() {
    }

    public StraightLineDirectionAction(Element element) {
        super(element);
    }

    @Override
    public String getElementName() {
        return "straight_line_dir";
    }

    @Override
    protected StraightLineDirectionAction make(Element element) {
        return new StraightLineDirectionAction(element);
    }

    public void setLineDirection(LineDirection lineDirection) {
        lineDirection.setDirectionAttributes(this);
    }

    @Override
    public void setFixedDirectionAttributes(Point2D directionVector) {
        float dx = (float)directionVector.getX();
        float dy = (float)directionVector.getY();
        this.setDirectionAttributes(dx, dy, 0, 0);
    }

    @Override
    public void setParallelDirectionAttributes(PointReference firstPoint, PointReference secondPoint) {
        int firstPointId = firstPoint.getId();
        int secondPointId = secondPoint.getId();
        this.setDirectionAttributes(0.0f, 0.0f, firstPointId, secondPointId);
    }

    private void setDirectionAttributes(float dx, float dy, int firstPointId, int secondPointId) {
        this.setFloatAttribute(DX, dx);
        this.setFloatAttribute(DY, dy);
        if (firstPointId > 0) {
            this.setIntAttribute(FIRST_POINT, firstPointId);
        }
        if (secondPointId > 0) {
            this.setIntAttribute(SECOND_POINT, secondPointId);
        }
    }

    public void setFixedPoint(ScriptoriumPoint fixedPoint) {
        this.setIntAttribute(FIXED_POINT, fixedPoint.getId());
    }

    @Override
    protected DraftVector getVector(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        int fixedPointId = this.getFixedPoint();
        double dx = this.getDx();
        double dy = this.getDy();
        int firstPointId = this.getFirstPoint();
        int secondPointId = this.getSecondPoint();
        ScriptoriumPoint fixedPoint = ShapeAdapter.getReferredItem(fixedPointId, drawingPoints);
        return GeometricHelper.getVector(fixedPoint, dx, dy, firstPointId, secondPointId, drawingPoints);
    }

    @Override
    public int getFirstPoint() {
        return this.getIntAttribute(FIRST_POINT);
    }

    @Override
    public int getSecondPoint() {
        return this.getIntAttribute(SECOND_POINT);
    }

    @Override
    public double getDx() {
        return this.getDoubleAttribute(DX);
    }

    @Override
    public double getDy() {
        return this.getDoubleAttribute(DY);
    }

    public int getFixedPoint() {
        return this.getIntAttribute(FIXED_POINT);
    }

    @Override
    public List<Integer> getFixedPointReferences() {
        return Arrays.asList(this.getFixedPoint());
    }

    @Override
    public String toString() {
        return "Straight line " + this.getFixedPoint() + " - dx: " + this.getDx() + " - dy: " + this.getDy();
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }
}

