/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftProjectionManager;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.homelinux.elabor.tools.MathUtils;

class HorizontalManager
implements DraftProjectionManager {
    HorizontalManager() {
    }

    @Override
    public void execute(DraftVector vector, ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
        double x = vector.getX();
        double y = vector.getY();
        double dx = vector.getDx();
        double dy = vector.getDy();
        if (dy == 0.0) {
            throw new InvalidValueException("horizontal projection is impossible");
        }
        double k = dx / dy;
        double yp = point.getY();
        double xt = MathUtils.round(x + (yp - y) * k, 3);
        point.setSnap(xt, yp);
    }

    public String toString() {
        return "HORIZONTAL".toLowerCase();
    }
}

