/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.AbstractPointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.ndraft.actions.ActionHelper;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftProjection;
import org.w3c.dom.Element;

public class ActionPoint
extends AbstractPointReference<ActionPoint>
implements ComponentFactory<ActionPoint> {
    private static final String PROJECTION = "projection";

    public ActionPoint() {
    }

    public ActionPoint(Element element) {
        super(element);
    }

    public ActionPoint(ScriptoriumPoint point, DraftProjection projection, EditionListener listener) {
        super(point);
        this.setId(point.getId());
        this.setProjection(projection);
        this.setListener(listener);
    }

    private void setProjection(DraftProjection projection) {
        String value = projection.toString();
        this.setStringAttribute(PROJECTION, value);
    }

    public DraftProjection getProjection(Iterable<ComputeAction> actions) {
        String key = this.getProjectionKey();
        DraftProjection projection = DraftProjection.getValue(key);
        if (projection == null) {
            Integer id = Integer.valueOf(key);
            ComputeAction action = ActionHelper.getAction(id, actions);
            projection = new DraftProjection(action);
        }
        return projection;
    }

    protected String getProjectionKey() {
        return this.getStringAttribute(PROJECTION).toUpperCase();
    }

    @Override
    public String getElementName() {
        return ComponentType.ACTIONPOINT.getName();
    }

    @Override
    public ActionPoint make(Element element) {
        return new ActionPoint(element);
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }
}

