/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.ndraft.ActionConstraintListener;
import org.homelinux.elabor.scriptorium.ndraft.PointListener;
import org.homelinux.elabor.scriptorium.ndraft.PointSetter;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.services.Highlighter;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class ChoosePointArea
extends JPanel {
    private static final long serialVersionUID = 1L;

    public ChoosePointArea(String label, PointSetter setter, GenericSelectionModel<ScriptoriumPoint> pointsModel, Map<ScriptoriumPoint, ComputeAction> pointsAction, Iterable<ComputeAction> actions, Iterable<ScriptoriumPoint> drawingPoints, boolean scroll) {
        LineBorder lineBorder = new LineBorder(Color.black);
        TitledBorder titledBorder = new TitledBorder(lineBorder, label);
        this.setBorder(titledBorder);
        Highlighter highlighter = new Highlighter(OntologyInitialiser.NULL);
        highlighter.setDrawingPoints(drawingPoints);
        this.setLayout(new GridBagLayout());
        JPanel pointsPane = new JPanel();
        pointsPane.setLayout(new GridBagLayout());
        ButtonGroup group = new ButtonGroup();
        int row = 0;
        for (ScriptoriumPoint point : pointsModel) {
            ArrayList<JCheckBox> actionCheckBoxes = new ArrayList<JCheckBox>();
            for (ComputeAction action : actions) {
                if (!action.isFixing(point)) continue;
                action.accept(highlighter);
                String text = highlighter.getText();
                JCheckBox actionCheckBox = new JCheckBox(text);
                actionCheckBox.setEnabled(true);
                ActionConstraintListener actionConstraintListener = new ActionConstraintListener(actionCheckBox, point, action, pointsAction);
                actionCheckBox.addItemListener(actionConstraintListener);
                actionCheckBoxes.add(actionCheckBox);
                int column = actionCheckBoxes.size();
                UITools.addComponent(pointsPane, actionCheckBox, column, row, 1, 1, 100, 10, 2, 2);
            }
            JRadioButton radioLlabel = new JRadioButton(point.toString());
            PointListener pointListener = new PointListener((JToggleButton)radioLlabel, setter, point, actionCheckBoxes);
            radioLlabel.addItemListener(pointListener);
            group.add(radioLlabel);
            UITools.addComponent(pointsPane, radioLlabel, 0, row, 1, 1, 10, 10, 2, 2);
            ++row;
        }
        if (scroll) {
            JScrollPane scrollPane = new JScrollPane(pointsPane);
            UITools.addComponent(this, scrollPane, 0, 0, 1, 1, 100, 100, 1, 2);
        } else {
            UITools.addComponent(this, pointsPane, 0, 0, 1, 1, 100, 100, 1, 2);
        }
    }
}

