/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.works;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.works.WorkFrame;
import org.homelinux.elabor.ui.GenericSelectionModel;

public class WorksPanel
extends OldScriptoriumListArea<Work> {
    private static final long serialVersionUID = 1L;
    private WorkFrame workFrame;

    public WorksPanel() {
        super(false, true, true);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.WORKS);
        this.setCellRenderer(renderer);
        LineBorder border = new LineBorder(Color.black);
        this.setBorder(border);
        this.workFrame = new WorkFrame();
    }

    @Override
    public void setup(ScriptoriumDirector director, Work work) {
        Edition edition = director.getEdition();
        Content content = edition.getContent();
        List<Work> works = content.getWorks();
        super.setup(director, works, work);
    }

    private void openWorkFrame(int index) {
        GenericSelectionModel<Work> model = this.getModel();
        this.workFrame.setup(model, index);
    }

    @Override
    public void addAction() {
    }

    @Override
    public void remAction(int index, Work work) {
        GenericSelectionModel model = this.getModel();
        model.removeElementAt(index);
        this.getDirector().downgradeComponent(work);
    }

    @Override
    public void editAction(int index, Work work) {
        this.openWorkFrame(index);
    }

    @Override
    public boolean closing() {
        if (this.workFrame != null) {
            this.workFrame.dispose();
        }
        return super.closing();
    }
}

