/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.variants;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.homelinux.elabor.scriptorium.ecomponents.Conspectus;
import org.homelinux.elabor.scriptorium.ecomponents.Description;
import org.homelinux.elabor.scriptorium.ecomponents.DescriptionItem;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.ecomponents.Witness;
import org.homelinux.elabor.scriptorium.ecomponents.WitnessesIds;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.variants.DescriptionItemFrame;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.GenericListModel;
import org.homelinux.elabor.ui.UITools;

public class DescriptionPanel
extends ScriptoriumPanel<Description>
implements MouseListener,
ListSelectionListener,
ActionListener {
    static final long serialVersionUID = 1L;
    private String witnessesString;
    private String addButtonString;
    private String addWitTooltip;
    private String removeButtonString;
    private String removeWitTooltip;
    private String addDesTooltip;
    private String removeDesTooltip;
    private VariantItem variantItem;
    private GenericListModel<Description> descriptions;
    private int index;
    private Description description;
    private DescriptionItemFrame descriptionItemFrame;
    private DefaultGenericSelectionModel<Witness> witnesses;
    private JLabel witnessesIdsLabel;
    private JComboBox<Witness> witnessesMenu;
    private JButton addWitIdButton;
    private JButton remWitIdButton;
    private DefaultGenericSelectionModel<DescriptionItem> descriptionItems;
    private JList<DescriptionItem> descriptionItemsList;
    private JButton addDesItemButton;
    private JButton remDesItemButton;

    public DescriptionPanel() {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        JLabel witIdsLabel = new JLabel(this.witnessesString, 4);
        int textFieldFontSize = preferences.getInteger("text_fields_font_size");
        this.witnessesIdsLabel = UITools.setupLabel("", textFieldFontSize);
        this.witnessesMenu = new JComboBox();
        this.addWitIdButton = UITools.setupButton(this.addButtonString, this.addWitTooltip, this);
        this.addWitIdButton.setEnabled(true);
        this.remWitIdButton = UITools.setupButton(this.removeButtonString, this.removeWitTooltip, this);
        this.remWitIdButton.setEnabled(true);
        this.descriptionItemsList = new JList();
        this.descriptionItemsList.setBackground(preferences.getColor("lists_bg_color"));
        this.descriptionItemsList.addMouseListener(this);
        this.descriptionItemsList.addListSelectionListener(this);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.NULL);
        this.descriptionItemsList.setCellRenderer(renderer);
        JScrollPane description_items_scroll = new JScrollPane(this.descriptionItemsList);
        this.addDesItemButton = UITools.setupButton(this.addButtonString, this.addDesTooltip, this);
        this.addDesItemButton.setEnabled(true);
        this.remDesItemButton = UITools.setupButton(this.removeButtonString, this.removeDesTooltip, this);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, witIdsLabel, 0, 0, 1, 2, 1, 1, 2, 2);
        UITools.addComponent(this, this.witnessesIdsLabel, 1, 0, 1, 2, 100, 1, 2, 2);
        UITools.addComponent(this, this.witnessesMenu, 2, 0, 2, 1, 100, 1, 2, 2);
        UITools.addComponent(this, this.addWitIdButton, 2, 1, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, this.remWitIdButton, 3, 1, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, description_items_scroll, 0, 2, 4, 1, 100, 100, 1, 5);
        UITools.addComponent(this, this.addDesItemButton, 0, 3, 2, 1, 1, 1, 0, 5);
        UITools.addComponent(this, this.remDesItemButton, 2, 3, 2, 1, 1, 1, 0, 5);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.witnessesString = catalog.translate("witnessesString");
        this.addButtonString = catalog.translate("addButtonString");
        this.addWitTooltip = catalog.translate("addWitTooltip");
        this.removeButtonString = catalog.translate("removeButtonString");
        this.removeWitTooltip = catalog.translate("removeWitTooltip");
        this.addDesTooltip = catalog.translate("addDesTooltip");
        this.removeDesTooltip = catalog.translate("removeDesTooltip");
    }

    public void setup(Edition edition, VariantItem variant_item, GenericListModel<Description> descriptions, int index) {
        this.variantItem = variant_item;
        this.descriptions = descriptions;
        this.index = index;
        this.description = index >= 0 ? this.descriptions.get(this.index).makeCopy(new Description()) : new Description(variant_item);
        WitnessesIds witnesses_ids = this.description.getWitnessesIds();
        this.witnessesIdsLabel.setText(witnesses_ids == null ? "---" : witnesses_ids.toString());
        this.initWitnessIdMenu(edition);
        this.descriptionItems = new DefaultGenericSelectionModel<DescriptionItem>(this.description.getItems());
        this.descriptionItemsList.setModel(this.descriptionItems);
    }

    private void initWitnessIdMenu(Edition edition) {
        Conspectus conspectus = edition.getHeader().getConspectus();
        this.witnesses = new DefaultGenericSelectionModel<Witness>(conspectus.getWitnesses());
        this.witnessesMenu.setModel(this.witnesses);
        if (this.witnesses.getSize() > 0) {
            this.witnessesMenu.setSelectedIndex(0);
        }
    }

    private void removeSelectedItem() {
        int removeIndex = this.descriptionItemsList.getSelectedIndex();
        DescriptionItem item = this.descriptionItems.get(removeIndex);
        this.description.removeItem(item);
        this.descriptionItems.removeElementAt(removeIndex);
    }

    private void openDescriptionItemFrame(int itemIndex) {
        if (this.descriptionItemFrame == null) {
            this.descriptionItemFrame = new DescriptionItemFrame(500, 150);
        }
        this.descriptionItemFrame.setup(this.description, this.descriptionItems, itemIndex);
    }

    @Override
    public boolean okAction() {
        if (this.index >= 0) {
            this.variantItem.replaceDescription(this.descriptions.get(this.index), this.description);
            this.descriptions.set(this.index, this.description);
        } else {
            this.variantItem.addDescription(this.description);
            this.descriptions.append(this.description);
        }
        return super.okAction();
    }

    @Override
    public boolean closing() {
        if (this.descriptionItemFrame != null) {
            this.descriptionItemFrame.dispose();
        }
        return super.closing();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.addWitIdButton || source == this.remWitIdButton) {
            int selectedIndex = this.witnessesMenu.getSelectedIndex();
            if (selectedIndex >= 0) {
                String wit_id = this.witnesses.get(selectedIndex).getId();
                if (source == this.addWitIdButton) {
                    this.description.addWitnessId(wit_id);
                } else {
                    this.description.removeWitnessId(wit_id);
                }
                WitnessesIds witnesses_ids = this.description.getWitnessesIds();
                this.witnessesIdsLabel.setText(witnesses_ids == null ? "---" : witnesses_ids.toString());
            }
        } else if (source == this.remDesItemButton) {
            this.removeSelectedItem();
        } else if (source == this.addDesItemButton) {
            this.openDescriptionItemFrame(-1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        int selectedIndex = this.descriptionItemsList.getSelectedIndex();
        this.remDesItemButton.setEnabled(selectedIndex >= 0);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        int eventIndex;
        Object source = event.getSource();
        if (event.getClickCount() == 2 && source == this.descriptionItemsList && (eventIndex = this.descriptionItemsList.locationToIndex(event.getPoint())) >= 0) {
            this.openDescriptionItemFrame(eventIndex);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

