/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.folia;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.itools.SearchableListModel;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.Conspectus;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Folium;
import org.homelinux.elabor.scriptorium.ecomponents.Witness;
import org.homelinux.elabor.scriptorium.ecomponents.WitnessId;
import org.homelinux.elabor.scriptorium.ecomponents.WitnessesIds;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class FoliumPanel
extends ScriptoriumPanel<Folium> {
    private static final long serialVersionUID = 1L;
    private Folium folium;
    private SearchableListModel<WitnessId, Witness> witnesses;
    private JComboBox<Witness> witnessesMenu;
    private JTextField pageField;
    private String idsLabelString;
    private String pageLabelString;

    public FoliumPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        JLabel idsLabel = new JLabel(this.idsLabelString, 4);
        JLabel pageLabel = new JLabel(this.pageLabelString, 4);
        this.witnessesMenu = new JComboBox();
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color fieldColor = preferences.getColor("text_fields_editable_bg_color");
        this.pageField = Tools.setupTextField(this, fontSize, fieldColor, frame);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, idsLabel, 0, 0, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, pageLabel, 0, 1, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, this.witnessesMenu, 1, 0, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, this.pageField, 1, 1, 1, 1, 10, 1, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.idsLabelString = catalog.translate("idsLabel");
        this.pageLabelString = catalog.translate("pageLabel");
    }

    @Override
    public void setup(ScriptoriumDirector director, Folium folium) {
        List<WitnessId> w_ids;
        this.setDirector(director);
        this.folium = folium;
        WitnessId w_id = null;
        WitnessesIds ids = this.folium.getIds();
        if (ids != null && (w_ids = ids.getWitnessIds()).size() > 0) {
            w_id = w_ids.get(0);
        }
        Edition edition = director.getEdition();
        this.initWitnessIdMenu(edition, w_id);
        this.pageField.setText(this.folium.getPage());
    }

    @Override
    public boolean okAction() {
        this.folium.setPage(this.pageField.getText());
        int selected_index = this.witnessesMenu.getSelectedIndex();
        this.folium.setWitnessId(((Witness)this.witnesses.get(selected_index)).getId());
        return super.okAction();
    }

    private void initWitnessIdMenu(Edition edition, WitnessId witness_id) {
        Conspectus conspectus = edition.getHeader().getConspectus();
        this.witnesses = new SearchableListModel(conspectus.getWitnesses());
        this.witnessesMenu.setModel(this.witnesses);
        Witness witness = this.witnesses.find(witness_id);
        if (witness == null) {
            if (this.witnesses.getSize() > 0) {
                this.witnessesMenu.setSelectedIndex(0);
            }
        } else {
            this.witnessesMenu.setSelectedItem(witness);
        }
    }
}

