/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.shapes;

import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.undo.UndoableEdit;
import org.homelinux.elabor.scriptorium.ndraft.HistoryListener;
import org.homelinux.elabor.scriptorium.ndraft.HistoryMouseListener;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingDirector;
import org.homelinux.elabor.scriptorium.ndraft.NDraftUndoManager;
import org.homelinux.elabor.ui.UITools;

public class ActionsArea
extends JPanel {
    private static final long serialVersionUID = 1L;
    private NDraftUndoManager undoManager;
    private final JTree historyTree;
    private HistoryMouseListener treeMouseListener;

    public ActionsArea() {
        this.setLayout(new GridBagLayout());
        this.historyTree = new JTree();
        this.historyTree.setRootVisible(true);
        JScrollPane scrollPanel = new JScrollPane(this.historyTree);
        UITools.addComponent(this, scrollPanel, 0, 0, 1, 1, 100, 100, 1, 2);
    }

    public void setup(NDraftDrawingDirector director) {
        this.undoManager = director.getUndoManager();
        this.undoManager.setListener(new HistoryListener(this));
        if (this.treeMouseListener != null) {
            this.historyTree.removeMouseListener(this.treeMouseListener);
        }
        this.treeMouseListener = new HistoryMouseListener(this, this.historyTree, this.undoManager);
        this.historyTree.addMouseListener(this.treeMouseListener);
        this.fillHistoryTree();
    }

    public void fillHistoryTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        UndoableEdit currentUndo = this.undoManager.editToBeUndone();
        String presentationName = "original stage";
        if (currentUndo == null) {
            presentationName = "<html><b>" + presentationName + "</b></html>";
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(presentationName);
        treeModel.insertNodeInto(node, root, 0);
        for (UndoableEdit edit : this.undoManager.getEdits()) {
            presentationName = edit.getPresentationName();
            if (currentUndo == edit) {
                presentationName = "<html><b>" + presentationName + "</b></html>";
            }
            node = new DefaultMutableTreeNode(presentationName);
            treeModel.insertNodeInto(node, root, 0);
        }
        this.historyTree.setModel(treeModel);
        this.historyTree.setRootVisible(false);
    }
}

