/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.points;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.UpDownArea;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapePanel;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;
import org.homelinux.elabor.ui.panel.ListArea;

public class PointReferencesArea
extends ListArea<PointReference> {
    private static final long serialVersionUID = 1L;
    private String splitLabelString;
    private String splitTooltipString;
    private JButton splitButton;
    private UpDownArea upDownArea;
    private ShapePanel shapePanel;
    private DrawingDirector director;

    public PointReferencesArea(ShapePanel shapePanel) {
        super(false, false, true);
        this.shapePanel = shapePanel;
        this.initLocale();
        this.upDownArea = new UpDownArea(this);
        this.splitButton = UITools.setupButton(this.splitLabelString, this.splitTooltipString, this, false);
        UITools.addComponent(this, this.upDownArea, 0, 1, 1, 4, 1, 100, 3, 2);
        UITools.addComponent(this, this.splitButton, 2, 4, 1, 1, 0, 100, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.splitLabelString = catalog.translate("splitLabel");
        this.splitTooltipString = catalog.translate("splitTooltip");
    }

    @Override
    public void setup(GenericSelectionModel<PointReference> pointsReferences, DrawingDirector director) {
        super.setup(pointsReferences);
        this.director = director;
        this.upDownArea.setup(pointsReferences);
    }

    private void splitAction(int index) {
        this.director.splitShape(index);
        this.shapePanel.closeWindow();
    }

    @Override
    public void addAction() {
    }

    @Override
    public void editAction(int index, PointReference item) {
    }

    @Override
    public void remAction(int index, PointReference element) {
        GenericSelectionModel<PointReference> model = this.getModel();
        model.removeElement(element);
    }

    @Override
    public void valueChanged(boolean notify) {
        this.upDownArea.valueChanged();
        int index = this.getSelectedIndex();
        this.splitButton.setEnabled(index >= 0);
        super.valueChanged(notify);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        int index = this.getSelectedIndex();
        if (source == this.splitButton) {
            this.splitAction(index);
        } else {
            super.actionPerformed(event);
        }
    }
}

