/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.operations;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.homelinux.elabor.csv.CsvReader;
import org.homelinux.elabor.csv.CsvReaderCloseable;
import org.homelinux.elabor.file.InvalidFileFormat;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UIConstants;

public class LabelConverter {
    private Map<String, String> map;
    private String lackMessageFirst;
    private String lackMessageSecond;
    private String conversionTableName;

    public LabelConverter(File conversionTable) throws IOException, InvalidFileFormat {
        this.initLocale();
        this.conversionTableName = this.getConversionTableName(conversionTable);
        this.map = new HashMap<String, String>();
        try (CsvReader reader = new CsvReader();){
            reader.setFile(conversionTable);
            while (reader.hasNext()) {
                String[] row = reader.getNextRow();
                if (row.length == 2) {
                    this.map.put(row[0], row[1]);
                    continue;
                }
                throw new InvalidFileFormat("row " + reader.getLineNumber() + " contains " + row.length + " columns");
            }
        }
    }

    public LabelConverter(String tableName, InputStream tableStream) throws IOException, InvalidFileFormat {
        this.initLocale();
        this.conversionTableName = tableName;
        this.map = new HashMap<String, String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (CsvReaderCloseable reader = new CsvReaderCloseable();){
            reader.setInputStream(tableStream);
            while (reader.hasNext()) {
                String[] row = reader.getNextRow();
                if (row.length == 2) {
                    this.map.put(row[0], row[1]);
                    continue;
                }
                throw new InvalidFileFormat("row " + reader.getLineNumber() + " contains " + row.length + " columns");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getConversionTableName(File conversionTable) throws IOException {
        File canonicalFile = conversionTable.getCanonicalFile();
        this.conversionTableName = canonicalFile.getName();
        return this.conversionTableName;
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.lackMessageFirst = catalog.translate("lackMessageFirst");
        this.lackMessageSecond = catalog.translate("lackMessageSecond");
    }

    public String convertCharacter(String from) {
        String to = this.map.get(from);
        if (to == null) {
            to = from;
            JOptionPane.showMessageDialog(null, String.valueOf(this.lackMessageFirst) + " " + this.conversionTableName + " " + this.lackMessageSecond + " '" + from + "' !", UIConstants.getInstance().errorString, 0);
        }
        return to;
    }
}

