/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.labels;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.homelinux.elabor.itools.DefaultPanel;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.labels.UnicodePanel;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointLabelListener;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;
import org.homelinux.elabor.ui.window.DefaultFrame;

public class LabelField
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField label;
    private JButton button;
    private String unicodeButtonTooltip;
    private DefaultFrame<UnicodePanel, String> frame;

    public LabelField(DefaultPanel<?> pointPanel, int fontSize, Color editableBgColor, ScriptoriumFrame<?> frame) {
        this.initLocale();
        this.label = Tools.setupTextField(pointPanel, fontSize, editableBgColor, frame);
        EditionManager manager = EditionManager.getInstance();
        URL iconUrl = manager.getIconUrl("unicode");
        this.button = UITools.createButton(iconUrl, null, this.unicodeButtonTooltip, this);
        this.button.setBorder(null);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.label, 0, 0, 1, 1, 100, 100, 1, 0);
        UITools.addComponent(this, this.button, 1, 0, 1, 1, 0, 0, 0, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.unicodeButtonTooltip = catalog.translate("unicodeButton");
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public void addKeyListener(PointLabelListener listener) {
        this.label.addKeyListener(listener);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.label.requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.openUnicodeFrame();
    }

    private void openUnicodeFrame() {
        UnicodePanel panel = new UnicodePanel();
        if (this.frame == null) {
            this.frame = new DefaultFrame(panel);
            this.frame.setSize(300, 200);
        }
        String text = this.label.getText();
        this.frame.setup(text);
    }

    public void closing() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }
}

