/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;
import org.homelinux.elabor.ui.panel.ListArea;

public class UpDownArea
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String UP_ICON_NAME = "up";
    private static final String DOWN_ICON_NAME = "down";
    private ListArea<?> listArea;
    private GenericSelectionModel<?> items;
    private String upTooltipString;
    private String downTooltipString;
    private JButton upButton;
    private JButton downButton;

    public UpDownArea(ListArea<?> listArea) {
        this.listArea = listArea;
        this.initLocale();
        EditionManager manager = EditionManager.getInstance();
        URL upIconUrl = manager.getIconUrl(UP_ICON_NAME);
        this.upButton = UITools.createButton(upIconUrl, null, this.upTooltipString, this);
        this.upButton.setBorder(null);
        this.upButton.setEnabled(false);
        URL downIconUrl = manager.getIconUrl(DOWN_ICON_NAME);
        this.downButton = UITools.createButton(downIconUrl, null, this.downTooltipString, this);
        this.downButton.setBorder(null);
        this.downButton.setEnabled(false);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.upButton, 1, 0, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.downButton, 1, 1, 1, 1, 0, 0, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        Preferences preferences = Preferences.getInstance();
        String locale = preferences.getProperty("locale");
        catalog.loadCatalog(UpDownArea.class.getName(), locale);
        this.upTooltipString = catalog.translate("upTooltip");
        this.downTooltipString = catalog.translate("downTooltip");
    }

    public void setup(GenericSelectionModel<?> items) {
        this.items = items;
    }

    public void valueChanged() {
        int[] indices = this.listArea.getSelectedIndices();
        int index = indices.length == 1 ? indices[0] : -1;
        int maxIndex = this.items.getSize() - 1;
        this.upButton.setEnabled(index > 0);
        this.downButton.setEnabled(index >= 0 && index < maxIndex);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        int[] indices = this.listArea.getSelectedIndices();
        if (indices.length == 1) {
            int index = indices[0];
            if (source == this.upButton) {
                this.items.moveDown(index - 1);
                this.listArea.setSelectedIndex(index - 1, true);
            } else if (source == this.downButton) {
                this.items.moveDown(index);
                this.listArea.setSelectedIndex(index + 1, true);
            }
        }
    }
}

