/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class GridPanel
extends ScriptoriumPanel<EditionComponent<?>> {
    static final long serialVersionUID = 1L;
    private JTextField gridSizeField;
    private String gridSize;
    private JTextField thickLineField;
    private String thickLine;
    private DrawingDirector drawingDirector;

    public GridPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        int labelSize = preferences.getInteger("label_font_size");
        int textSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        JLabel gridSizeLabel = UITools.setupLabel(this.gridSize, labelSize);
        this.gridSizeField = Tools.setupTextField(this, textSize, editableBgColor, frame);
        JLabel thickLineLabel = UITools.setupLabel(this.thickLine, labelSize);
        this.thickLineField = Tools.setupTextField(this, textSize, editableBgColor, frame);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, gridSizeLabel, 0, 0, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.gridSizeField, 1, 0, 1, 1, 100, 100, 2, 2);
        UITools.addComponent(this, thickLineLabel, 0, 1, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.thickLineField, 1, 1, 1, 1, 100, 100, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName());
        this.gridSize = catalog.translate("gridSize");
        this.thickLine = catalog.translate("thickLine");
    }

    public void setup(DrawingDirector drawingDirector) {
        this.drawingDirector = drawingDirector;
        Preferences preferences = Preferences.getInstance();
        this.gridSizeField.setText(preferences.getString("grid_size"));
        this.thickLineField.setText(preferences.getString("thick_line"));
    }

    @Override
    public boolean okAction() {
        int thickness;
        int size;
        Preferences preferences = Preferences.getInstance();
        String gridSizeText = this.gridSizeField.getText();
        try {
            size = Integer.parseInt(gridSizeText);
        }
        catch (NumberFormatException e) {
            size = preferences.getInteger("grid_size");
        }
        if (size == 0) {
            size = 10;
        }
        gridSizeText = String.valueOf(size);
        preferences.setProperty("grid_size", gridSizeText);
        try {
            thickness = Integer.valueOf(this.thickLineField.getText());
        }
        catch (NumberFormatException e) {
            thickness = preferences.getInteger("thick_line");
        }
        preferences.setProperty("thick_line", String.valueOf(thickness));
        preferences.save();
        this.drawingDirector.reloadGrid();
        return true;
    }
}

