/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoManager;
import org.homelinux.elabor.file.InvalidFileFormat;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Arc;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Bezier;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.CircleByCenter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Ellipse;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.EllipseByPoints;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Line;
import org.homelinux.elabor.scriptorium.gui.EditionComponentFrame;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.DefaultDrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.DefaultDrawingPalette;
import org.homelinux.elabor.scriptorium.gui.drawings.DiagramsDrawingFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.DraftExportDirectorFactory;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.operations.ApplyStylesetAction;
import org.homelinux.elabor.scriptorium.gui.drawings.operations.ExportSvgAction;
import org.homelinux.elabor.scriptorium.gui.drawings.operations.LabelConvertAction;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UIConstants;

public class DrawingFrame
extends EditionComponentFrame<Drawing, DrawingPanel> {
    private static final String CONVERSION_TABLES = "conversion_tables";
    static final long serialVersionUID = 1L;
    private String editLabel;
    private String undoLabel;
    private String redoLabel;
    private String translateDrawingLabel;
    private String magnificateDrawingLabel;
    private String rotateDrawingLabel;
    private String invertDrawingLabel;
    private String optionsLabel;
    private String attributesLabel;
    private String exportableAreaLabel;
    private String toggleVisibilityLabel;
    private String labelsAndRectanglesLabel;
    private String backgroundAndDrawingLabel;
    private String shadingLabel;
    private String toggleGridLabel;
    private String snapToGridLabel;
    private String setGridLabel;
    private String backgroundLabel;
    private String setImageLabel;
    private String removeImageLabel;
    private String transformImageLabel;
    private String shapesLabel;
    private String lineLabel;
    private String circleByCenterLabel;
    private String circleByApproxLabel;
    private String ellipseLabel;
    private String ellipseByPointsLabel;
    private String arcLabel;
    private String curveOfBezierLabel;
    private String stylesLabel;
    private String loadStylesLabel;
    private String editStylesLabel;
    private String saveStylesLabel;
    private String conversionsLabel;
    private String applyStylesetLabel;
    private String convertLabelsLabel;
    private String exportSvgLabel;
    private String infoMenuLabel;
    private String infoLabel;
    private JMenuItem undoJMI;
    private JMenuItem redoJMI;
    private JMenuItem translateDrawingJMI;
    private JMenuItem magnificateDrawingJMI;
    private JMenuItem rotateDrawingJMI;
    private JMenuItem invertDrawingJMI;
    private JMenuItem attributesJMI;
    private JMenuItem exportableAreaJMI;
    private JCheckBoxMenuItem toggleVisibilityJMI;
    private JMenuItem backgroundAndDrawingJMI;
    private JMenuItem labelsAndRectanglesJMI;
    private JCheckBoxMenuItem shadingJMI;
    private JCheckBoxMenuItem toggleGridJMI;
    private JCheckBoxMenuItem snapToGridJMI;
    private JMenuItem setGridJMI;
    private JMenuItem setImageJMI;
    private JMenuItem removeImageJMI;
    private JMenuItem transformImageJMI;
    private JMenuItem lineJMI;
    private JMenuItem circleByCenterJMI;
    private JMenuItem circleByApproxJMI;
    private JMenuItem ellipseJMI;
    private JMenuItem ellipseByPointsJMI;
    private JMenuItem arcJMI;
    private JMenuItem curveOfBezierJMI;
    private JMenuItem loadStylesJMI;
    private JMenuItem editStylesJMI;
    private JMenuItem saveStylesJMI;
    private JMenuItem applyStylesetJMI;
    private JMenuItem convertLabelsJMI;
    private JMenuItem exportSvgJMI;
    private JMenuItem infoJMI;
    private String theresAStylesetString;
    private String wantSaveString;
    private int backgroundAndDrawing;
    private int labelsAndRectangles;

    public DrawingFrame() {
        super(new DrawingPanel());
        this.setSize(800, 600);
        this.initLocale();
        this.backgroundAndDrawing = 0;
        this.initMenubar();
        this.setConversionsEnabled(false);
    }

    protected void initLocale() {
        String locale = Preferences.getInstance().getProperty("locale");
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(DrawingFrame.class.getName(), locale);
        this.editLabel = catalog.translate("edit");
        this.undoLabel = catalog.translate("undo");
        this.redoLabel = catalog.translate("redo");
        this.translateDrawingLabel = catalog.translate("translateDrawing");
        this.magnificateDrawingLabel = catalog.translate("magnificateDrawing");
        this.rotateDrawingLabel = catalog.translate("rotateDrawing");
        this.invertDrawingLabel = catalog.translate("invertDrawing");
        this.optionsLabel = catalog.translate("options");
        this.attributesLabel = catalog.translate("attributes");
        this.exportableAreaLabel = catalog.translate("exportableArea");
        this.toggleVisibilityLabel = catalog.translate("toggleVisibility");
        this.backgroundAndDrawingLabel = catalog.translate("backgroundAndDrawing");
        this.labelsAndRectanglesLabel = catalog.translate("labelsAndRectangles");
        this.shadingLabel = catalog.translate("showShading");
        this.toggleGridLabel = catalog.translate("toggleGrid");
        this.snapToGridLabel = catalog.translate("snapToGrid");
        this.setGridLabel = catalog.translate("setGrid");
        this.backgroundLabel = catalog.translate("background");
        this.setImageLabel = catalog.translate("setImage");
        this.removeImageLabel = catalog.translate("removeImage");
        this.transformImageLabel = catalog.translate("transformImage");
        this.stylesLabel = catalog.translate("styles");
        this.loadStylesLabel = catalog.translate("loadStyles");
        this.editStylesLabel = catalog.translate("editStyles");
        this.saveStylesLabel = catalog.translate("saveStyles");
        this.infoMenuLabel = catalog.translate("infoMenu");
        this.conversionsLabel = catalog.translate("batchMenu");
        this.applyStylesetLabel = catalog.translate("applyStyleset");
        this.convertLabelsLabel = catalog.translate("convertLabels");
        this.exportSvgLabel = catalog.translate("exportSvg");
        this.infoLabel = catalog.translate("info");
        this.theresAStylesetString = catalog.translate("theresAStyleset");
        MessageCatalog catalogA = new MessageCatalog();
        catalogA.loadCatalog(DiagramsDrawingFrame.class.getName(), locale);
        this.wantSaveString = catalogA.translate("wantSave");
        MessageCatalog catalogB = new MessageCatalog();
        catalogB.loadCatalog(DrawingPanel.class.getName(), locale);
        this.shapesLabel = catalogB.translate("shapesAreaTitle");
        MessageCatalog catalogC = new MessageCatalog();
        catalogC.loadCatalog(DefaultDrawingPalette.class.getName(), locale);
        this.lineLabel = catalogC.translate("line_label");
        this.circleByCenterLabel = catalogC.translate("circleByCenter_label");
        this.circleByApproxLabel = catalogC.translate("circleByApprox_label");
        this.ellipseLabel = catalogC.translate("ellipse_label");
        this.ellipseByPointsLabel = catalogC.translate("ellipseByPoints_label");
        this.arcLabel = catalogC.translate("arc_label");
        this.curveOfBezierLabel = catalogC.translate("curveOfBezier_label");
    }

    public void resetOptions() {
        this.backgroundAndDrawing = 0;
        DrawingPanel panel = (DrawingPanel)this.getPanel();
        panel.setShowDrawing(true);
        panel.setShowBackground(true);
    }

    protected void initMenubar() {
        Preferences prefer = Preferences.getInstance();
        boolean magnetic = prefer.getBoolean("snap_to_grid");
        boolean showInvisibles = prefer.getBoolean("show_invisibles");
        boolean showBackground = prefer.getBoolean("show_background_image");
        boolean showLabels = prefer.getBoolean("show_labels");
        boolean shading = prefer.getBoolean("shading");
        boolean showGrid = prefer.getBoolean("show_grid");
        JMenu edit = new JMenu(this.editLabel);
        this.undoJMI = new JMenuItem(this.undoLabel);
        this.redoJMI = new JMenuItem(this.redoLabel);
        this.undoJMI.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.redoJMI.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.translateDrawingJMI = new JMenuItem(this.translateDrawingLabel);
        this.magnificateDrawingJMI = new JMenuItem(this.magnificateDrawingLabel);
        this.rotateDrawingJMI = new JMenuItem(this.rotateDrawingLabel);
        this.invertDrawingJMI = new JMenuItem(this.invertDrawingLabel);
        edit.add(this.undoJMI);
        edit.add(this.redoJMI);
        edit.addSeparator();
        edit.add(this.translateDrawingJMI);
        edit.add(this.magnificateDrawingJMI);
        edit.add(this.rotateDrawingJMI);
        edit.add(this.invertDrawingJMI);
        JMenu options = new JMenu(this.optionsLabel);
        this.attributesJMI = new JMenuItem(this.attributesLabel);
        this.exportableAreaJMI = new JMenuItem(this.exportableAreaLabel);
        this.toggleVisibilityJMI = new JCheckBoxMenuItem(this.toggleVisibilityLabel, showInvisibles);
        this.backgroundAndDrawingJMI = new JMenuItem(this.backgroundAndDrawingLabel);
        this.labelsAndRectanglesJMI = new JMenuItem(this.labelsAndRectanglesLabel);
        this.shadingJMI = new JCheckBoxMenuItem(this.shadingLabel, shading);
        this.toggleGridJMI = new JCheckBoxMenuItem(this.toggleGridLabel, showGrid);
        this.snapToGridJMI = new JCheckBoxMenuItem(this.snapToGridLabel, magnetic);
        this.setGridJMI = new JMenuItem(this.setGridLabel);
        this.toggleVisibilityJMI.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.backgroundAndDrawingJMI.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.labelsAndRectanglesJMI.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        options.add(this.attributesJMI);
        options.addSeparator();
        options.add(this.exportableAreaJMI);
        options.add(this.toggleVisibilityJMI);
        options.add(this.shadingJMI);
        options.add(this.backgroundAndDrawingJMI);
        options.add(this.labelsAndRectanglesJMI);
        options.addSeparator();
        options.add(this.toggleGridJMI);
        options.add(this.snapToGridJMI);
        options.add(this.setGridJMI);
        JMenu background = new JMenu(this.backgroundLabel);
        this.setImageJMI = new JMenuItem(this.setImageLabel);
        this.removeImageJMI = new JMenuItem(this.removeImageLabel);
        this.transformImageJMI = new JMenuItem(this.transformImageLabel);
        this.setImageJMI.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.removeImageJMI.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.transformImageJMI.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        background.add(this.setImageJMI);
        background.add(this.removeImageJMI);
        background.add(this.transformImageJMI);
        JMenu shapes = new JMenu(this.shapesLabel);
        this.lineJMI = new JMenuItem(this.lineLabel);
        this.circleByCenterJMI = new JMenuItem(this.circleByCenterLabel);
        this.circleByApproxJMI = new JMenuItem(this.circleByApproxLabel);
        this.ellipseJMI = new JMenuItem(this.ellipseLabel);
        this.ellipseByPointsJMI = new JMenuItem(this.ellipseByPointsLabel);
        this.arcJMI = new JMenuItem(this.arcLabel);
        this.curveOfBezierJMI = new JMenuItem(this.curveOfBezierLabel);
        this.lineJMI.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        this.circleByCenterJMI.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.circleByApproxJMI.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        this.ellipseJMI.setAccelerator(KeyStroke.getKeyStroke(70, 8));
        this.ellipseByPointsJMI.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        this.arcJMI.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.curveOfBezierJMI.setAccelerator(KeyStroke.getKeyStroke(66, 8));
        shapes.add(this.lineJMI);
        shapes.add(this.circleByCenterJMI);
        shapes.add(this.ellipseJMI);
        shapes.add(this.arcJMI);
        shapes.add(this.curveOfBezierJMI);
        shapes.add(this.circleByApproxJMI);
        shapes.add(this.ellipseByPointsJMI);
        JMenu styles = new JMenu(this.stylesLabel);
        this.loadStylesJMI = new JMenuItem(this.loadStylesLabel);
        this.editStylesJMI = new JMenuItem(this.editStylesLabel);
        this.saveStylesJMI = new JMenuItem(this.saveStylesLabel);
        styles.add(this.loadStylesJMI);
        styles.add(this.editStylesJMI);
        styles.add(this.saveStylesJMI);
        JMenu conversions = this.setConversionsMenu();
        this.convertLabel();
        this.undoJMI.addActionListener(this);
        this.redoJMI.addActionListener(this);
        this.translateDrawingJMI.addActionListener(this);
        this.magnificateDrawingJMI.addActionListener(this);
        this.rotateDrawingJMI.addActionListener(this);
        this.invertDrawingJMI.addActionListener(this);
        this.attributesJMI.addActionListener(this);
        this.exportableAreaJMI.addActionListener(this);
        this.toggleVisibilityJMI.addActionListener(this);
        this.backgroundAndDrawingJMI.addActionListener(this);
        this.labelsAndRectanglesJMI.addActionListener(this);
        this.shadingJMI.addActionListener(this);
        this.toggleGridJMI.addActionListener(this);
        this.snapToGridJMI.addActionListener(this);
        this.setGridJMI.addActionListener(this);
        this.setImageJMI.addActionListener(this);
        this.transformImageJMI.addActionListener(this);
        this.removeImageJMI.addActionListener(this);
        this.lineJMI.addActionListener(this);
        this.circleByCenterJMI.addActionListener(this);
        this.circleByApproxJMI.addActionListener(this);
        this.ellipseJMI.addActionListener(this);
        this.ellipseByPointsJMI.addActionListener(this);
        this.arcJMI.addActionListener(this);
        this.curveOfBezierJMI.addActionListener(this);
        this.loadStylesJMI.addActionListener(this);
        this.editStylesJMI.addActionListener(this);
        this.saveStylesJMI.addActionListener(this);
        this.applyStylesetJMI.addActionListener(new ApplyStylesetAction());
        DraftExportDirectorFactory exportFactory = new DraftExportDirectorFactory();
        this.exportSvgJMI.addActionListener(new ExportSvgAction(exportFactory));
        JMenu info = new JMenu(this.infoMenuLabel);
        this.infoJMI = new JMenuItem(this.infoLabel);
        info.add(this.infoJMI);
        this.infoJMI.addActionListener(this);
        JMenuBar mainMenu = new JMenuBar();
        mainMenu.add(edit);
        mainMenu.add(options);
        mainMenu.add(background);
        mainMenu.add(shapes);
        mainMenu.add(styles);
        mainMenu.add(conversions);
        mainMenu.add(info);
        this.setJMenuBar(mainMenu);
        DrawingPanel panel = (DrawingPanel)this.getPanel();
        panel.setShowInvisibles(showInvisibles);
        panel.setShowBackground(showBackground);
        panel.setShowDrawing(true);
        panel.setShowLabels(showLabels);
        panel.setShowPointRectangles(true);
        panel.setShading(shading);
        panel.setShowGrid(showGrid);
        panel.setMagnetic(magnetic);
    }

    private JMenu setConversionsMenu() {
        JMenu conversions = new JMenu(this.conversionsLabel);
        this.applyStylesetJMI = new JMenuItem(this.applyStylesetLabel);
        this.convertLabelsJMI = new JMenu(this.convertLabelsLabel);
        this.exportSvgJMI = new JMenuItem(this.exportSvgLabel);
        conversions.add(this.applyStylesetJMI);
        conversions.add(this.convertLabelsJMI);
        conversions.add(this.exportSvgJMI);
        return conversions;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void convertLabel() {
        classLoader = this.getClass().getClassLoader();
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                inputStream = classLoader.getResourceAsStream("conversion_tables/list");
                try {
                    br = new BufferedReader(new InputStreamReader(inputStream));
                    ** try [egrp 3[TRYBLOCK] [2 : 39->190)] { 
lbl10:
                    // 1 sources

                    ** GOTO lbl-1000
lbl11:
                    // 1 sources

                    finally {
                        if (br != null) {
                            br.close();
                        }
                    }
                }
                catch (Throwable var3_6) {
                    if (var2_2 == null) {
                        var2_2 = var3_6;
                    } else if (var2_2 != var3_6) {
                        var2_2.addSuppressed(var3_6);
                    }
                    if (inputStream == null) throw var2_2;
                    inputStream.close();
                    throw var2_2;
                }
            }
            catch (Throwable var3_7) {
                if (var2_2 == null) {
                    var2_2 = var3_7;
                    throw var2_2;
                }
                if (var2_2 == var3_7) throw var2_2;
                var2_2.addSuppressed(var3_7);
                throw var2_2;
            }
        }
        catch (IOException | InvalidFileFormat exc) {
            throw new RuntimeException(exc);
        }
lbl-1000:
        // 4 sources

        {
            while ((tableName = br.readLine()) != null) {
                tableJMI = new JMenuItem(tableName);
                var8_12 = null;
                var9_14 = null;
                try {
                    tableStream = classLoader.getResourceAsStream("conversion_tables/" + tableName + ".csv");
                    try {
                        action = new LabelConvertAction(tableName, tableStream);
                        tableJMI.addActionListener(action);
                        this.convertLabelsJMI.add(tableJMI);
                    }
                    finally {
                        if (tableStream == null) continue;
                        tableStream.close();
                    }
                }
                catch (Throwable var9_15) {
                    if (var8_12 == null) {
                        var8_12 = var9_15;
                        throw var8_12;
                    }
                    if (var8_12 == var9_15) throw var8_12;
                    var8_12.addSuppressed(var9_15);
                    throw var8_12;
                }
            }
        }
        if (inputStream == null) return;
        inputStream.close();
    }

    public DefaultDrawingDirector getDrawingDirector() {
        DrawingPanel panel = (DrawingPanel)this.getPanel();
        return panel.getDrawingDirector();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        DefaultDrawingDirector director = this.getDrawingDirector();
        if (director != null) {
            EllipseByPoints innerShape;
            if (source == this.lineJMI) {
                director.addShape(new Line());
            } else if (source == this.circleByCenterJMI) {
                director.addShape(new CircleByCenter());
            } else if (source == this.circleByApproxJMI) {
                innerShape = new EllipseByPoints();
                director.addShape(innerShape);
                innerShape.setCircle(true);
            } else if (source == this.ellipseJMI) {
                director.addShape(new Ellipse());
            } else if (source == this.ellipseByPointsJMI) {
                innerShape = new EllipseByPoints();
                director.addShape(innerShape);
                innerShape.setCircle(false);
            } else if (source == this.arcJMI) {
                director.addShape(new Arc());
            } else if (source == this.saveStylesJMI) {
                director.saveStyleset();
            } else if (source == this.curveOfBezierJMI) {
                director.addShape(new Bezier());
            } else if (source == this.undoJMI) {
                director.undo();
            } else if (source == this.redoJMI) {
                director.redo();
            }
        }
        DrawingPanel panel = (DrawingPanel)this.getPanel();
        if (source == this.translateDrawingJMI) {
            panel.openDrawingTranslationForm();
        } else if (source == this.magnificateDrawingJMI) {
            panel.openDrawingMagnificationForm();
        } else if (source == this.rotateDrawingJMI) {
            panel.openDrawingRotationForm();
        } else if (source == this.invertDrawingJMI) {
            panel.openDrawingInversionForm();
        } else if (source == this.attributesJMI) {
            panel.openAttributesForm();
        } else if (source == this.exportableAreaJMI) {
            panel.openExportableAreaForm();
        } else if (source == this.toggleVisibilityJMI) {
            panel.setShowInvisibles(this.toggleVisibilityJMI.getState());
        } else if (source == this.backgroundAndDrawingJMI) {
            this.backgroundAndDrawing = this.getBackgroundAndDrawing();
            this.setShowBackgroundAndDrawing(panel);
        } else if (source == this.labelsAndRectanglesJMI) {
            this.labelsAndRectangles = this.getLabelsAndRectangles();
            this.setShowLabelsAndRectangles(panel);
        } else if (source == this.shadingJMI) {
            panel.setShading(this.shadingJMI.getState());
        } else if (source == this.toggleGridJMI) {
            panel.setShowGrid(this.toggleGridJMI.getState());
        } else if (source == this.snapToGridJMI) {
            panel.setMagnetic(this.snapToGridJMI.getState());
        } else if (source == this.setGridJMI) {
            panel.setGrid();
            panel.setShowGrid(this.toggleGridJMI.getState());
        } else if (source == this.loadStylesJMI) {
            if (this.checkStylesetSaved()) {
                panel.loadStyleset();
            }
        } else if (source == this.editStylesJMI) {
            panel.openStylesFrame();
        } else if (source == this.setImageJMI) {
            panel.loadBackgroundImage();
        } else if (source == this.removeImageJMI) {
            panel.unloadBackgroundImage();
        } else if (source == this.transformImageJMI) {
            panel.openBackgroundImageTransformForm();
        } else if (source == this.infoJMI) {
            panel.showReleaseFrame();
        } else {
            super.actionPerformed(event);
        }
    }

    private int getBackgroundAndDrawing() {
        ++this.backgroundAndDrawing;
        if (this.backgroundAndDrawing == 3) {
            this.backgroundAndDrawing = 0;
        }
        return this.backgroundAndDrawing;
    }

    private int getLabelsAndRectangles() {
        ++this.labelsAndRectangles;
        if (this.labelsAndRectangles == 3) {
            this.labelsAndRectangles = 0;
        }
        return this.labelsAndRectangles;
    }

    private void setShowLabelsAndRectangles(DrawingPanel panel) {
        if (this.labelsAndRectangles == 0) {
            panel.setShowLabels(true);
            panel.setShowPointRectangles(true);
        } else if (this.labelsAndRectangles == 1) {
            panel.setShowLabels(false);
            panel.setShowPointRectangles(true);
        } else if (this.labelsAndRectangles == 2) {
            panel.setShowLabels(false);
            panel.setShowPointRectangles(false);
        }
    }

    private void setShowBackgroundAndDrawing(DrawingPanel panel) {
        if (this.backgroundAndDrawing == 0) {
            panel.setShowDrawing(true);
            panel.setShowBackground(true);
        } else if (this.backgroundAndDrawing == 1) {
            panel.setShowDrawing(true);
            panel.setShowBackground(false);
        } else if (this.backgroundAndDrawing == 2) {
            panel.setShowDrawing(false);
            panel.setShowBackground(true);
        }
    }

    public boolean checkStylesetSaved() {
        boolean save = true;
        DefaultDrawingDirector director = this.getDrawingDirector();
        if (director.isStylesetChanged()) {
            int option = JOptionPane.showConfirmDialog(null, String.valueOf(this.theresAStylesetString) + " " + this.wantSaveString, UIConstants.getInstance().warningString, 1);
            if (option == 0) {
                director.saveStyleset();
            } else {
                save = option == 1;
            }
        }
        return save;
    }

    public void updateUndoRedo(UndoManager undoManager) {
        boolean canUndo = undoManager.canUndo();
        boolean canRedo = undoManager.canRedo();
        this.undoJMI.setEnabled(canUndo);
        this.redoJMI.setEnabled(canRedo);
    }

    public void setConversionsEnabled(boolean show) {
        this.applyStylesetJMI.setEnabled(show);
        this.convertLabelsJMI.setEnabled(show);
        this.exportSvgJMI.setEnabled(show);
    }
}

